#= require ./behavior

class window.Bookmark extends window.Behavior
  init: ->
    @referenceId = @data('reference-id')
    @type = @data('type')
    @$dom.click =>
      @toggleBookmark()


  isBookmarked: ->
    @data('has-bookmark') && @data('has-bookmark') > 0 

  toggleBookmark: ->
    if @isBookmarked()
      @removeBookmark()
    else
      @addBookmark()

  addBookmark: ->
    $.ajax
      url: settings.baseUrl+"/bookmark/add"
      data:
        id_reference: @referenceId
        type: @type
      success: =>
        @$dom.attr 'class', 'icon-bookmark'
        @$dom.data 'has-bookmark', '1'

  removeBookmark: ->
    $.ajax
      url: settings.baseUrl+"/bookmark/remove"
      data:
        id_reference: @referenceId
        type: @type
      success: =>
        @$dom.attr 'class', 'icon-bookmark-empty'
        @$dom.data 'has-bookmark', '0'
