/* ============================================================
 * One More All 0.1 for Bootstrap by Twitter
 * ============================================================
 * Copyright (C) 2013 Federico Parodi <federico.parodi@welaika.com>

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============================================================ */

!function ($) {

  var OneMoreAll = function (element, options) {
    this.$element = $(element)
    this.options = $.extend({}, options)
    this.container = this.options.container;
    this.render();
  }

  OneMoreAll.prototype.render = function () {
    this.allButton = $("<button id='" + this.options.domain + "-all' class='btn' style='margin-right: 5px;'>" + this.options.allLabel + "</button>");
    this.$element.append(this.allButton);
    var typeString = 'buttons-checkbox';
    if (this.options.radio) typeString = 'buttons-radio';
    this.group = $("<div class='btn-group' data-toggle='" + typeString + "' id='" + this.options.domain + "-group'></div>");
    var buttons = new Array();
     
    for ( var counter = 0; counter < this.options.buttons.length; counter++ ) {
      var button = this.options.buttons[counter];
      buttons.push("<button class='btn' id='" + this.options.domain + counter + "' data-" + this.options.domain + "-id='" + button.id + "'>" + button.title + "</button>");
      this.group.append(buttons[counter]);
    }
    this.$element.append(this.group);
    var _this = this;
    $(this.allButton).click(function() {_this.toggleAll()});
    $("button", this.group).click(function(){
      $(_this.allButton).removeClass('active');
      _this.toggleGate(this);
    });

    _this.allButton.click();
  }
  
  OneMoreAll.prototype.emptyContainer = function () {
    while (this.container.length > 0) {
      this.container.pop();
    }
  }

  OneMoreAll.prototype.refreshGatesArray = function (origin, state) {
      var _this = this;
      this.emptyContainer();
      if (origin == null) {
        $("button", this.group).each(function() {
          if ($(this).hasClass("active"))
              _this.container.push($(this).data(_this.options.domain + "-id"));
        });
      }
            
      else
        if (state) {
          _this.container.push($(origin).data(_this.options.domain + "-id"));
          if (this.options.radio) return;
        }
        $(origin).siblings().each(function() {
          if ($(this).hasClass("active"))
            _this.container.push($(this).data(_this.options.domain + "-id"))
        })
          
        if (_this.container.length == 0) {
          $(_this.allButton).click()
          $(origin).button('toggle')
        }
  }

  OneMoreAll.prototype.toggleGate = function (origin) {
      var state = false;
      if (!$(origin).hasClass('active'))
        state = true;
      this.refreshGatesArray(origin, state)
      //findEvents()
  }

  OneMoreAll.prototype.toggleAll = function () {
    _this = this;
    this.emptyContainer();
      if (!$(this.allButton).hasClass('active')) {
        $("button", this.group).removeClass('active');
        $("button", this.group).each(function() {
          _this.container.push($(this).data(_this.options.domain + "-id"));
        });
      }
      else {
        $("button:first", _this.group).addClass('active')
        _this.refreshGatesArray(null,false)
      }
      $(_this.allButton).button('toggle')
      //findEvents()
  }

  var old = $.fn.oneMoreAll

  $.fn.oneMoreAll = function (option) {
    return this.each(function () {
      var $this = $(this)
        , data = $this.data('oneMoreAll')
        , options = typeof option == 'object' && option
      if (!data) $this.data('oneMoreAll', (data = new OneMoreAll(this, options ? option : null)))
    })
  }

  $.fn.oneMoreAll.Constructor = OneMoreAll

  $.fn.oneMoreAll.noConflict = function () {
    $.fn.oneMoreAll = old
    return this
  }

}(window.jQuery);