<?php

class ArrayINI implements ArrayAccess, IteratorAggregate {
	private $lang;

	public function __construct($ini) {
		$this->lang = parse_ini_file($ini);
	}

	function __invoke($offset) {
		return $this->offsetGet($offset);
	}

	public function getIterator() {
		return new ArrayIterator($this->lang);
	}

	public function offsetSet($offset, $value) {
		if (is_null($offset)) {
			$this->lang[] = $value;
		} else {
			$this->lang[$offset] = $value;
		}
	}

	public function offsetExists($offset) {
		return isset($this->lang[$offset]);
	}

	public function offsetUnset($offset) {
		unset($this->lang[$offset]);
	}

	public function offsetGet($offset) {
		return isset($this->lang[$offset]) ? $this->lang[$offset] : null;
	}
}