<?php

class MyDbMigration extends CDbMigration
{

  /**
   *
   * @return boolean
   */
  public static function done()
  {
    $migration = get_called_class ();
    return Migration::model ()->exists ( 'version=:name', array (
        ':name' => $migration 
    ) );
  }

  /**
   *
   * @param string $sql          
   * @param array $params          
   * @return CDbDataReader
   */
  public function select($sql, array $params = array())
  {
    echo "    > select SQL: $sql ...";
    return $this->getDbConnection ()
      ->createCommand ( $sql )
      ->query ( $params );
  }

  /**
   *
   * @return CDbSchema
   */
  public function getSchema()
  {
    if ($this->dbConnection != null)
      if ($this->dbConnection->schema != null)
        return $this->dbConnection->schema;
    return null;
  }

  /**
   *
   * @param string $name          
   * @param boolean $refresh
   *          default=false
   * @return CDbTableSchema
   */
  public function getTable($name, $refresh = false)
  {
    $schema = $this->getSchema ();
    if ($schema != null)
      return $schema->getTable ( $name, $refresh );
    return null;
  }

  /**
   *
   * @param string $table          
   * @param string $column          
   * @return CDbColumnSchema
   */
  public function getColumn($table, $column)
  {
    $table = $this->getTable ( $table );
    if ($table != null)
      return $table->getColumn ( $column );
    return null;
  }

  /**
   *
   * @param string $table          
   * @param string $column          
   * @return boolean
   */
  public function columnExists($table, $column)
  {
    return $this->getColumn ( $table, $column ) != null;
  }

  /**
   * (non-PHPdoc)
   *
   * @see CDbMigration::addColumn()
   * @return boolean
   */
  public function addColumn($table, $column, $type)
  {
    if (! $this->columnExists ( $table, $column ))
    {
      parent::addColumn ( $table, $column, $type );
      return true;
    }
    return false;
  }

  /**
   * (non-PHPdoc)
   *
   * @see CDbMigration::renameColumn()
   * @return boolean
   */
  public function renameColumn($table, $name, $newName)
  {
    if ($this->columnExists ( $table, $name ))
    {
      parent::renameColumn ( $table, $name, $newName );
      return true;
    }
    return false;
  }
  
  
  public function renameTable($table, $newName)
  {
  	if ($this->getTable ( $table ) && !$this->getTable ( $table ))
  	{
  		parent::renameTable ( $table, $newName );
  		return true;
  	}
  	return false;
  }
  
  public function indexExist($name, $table)
  {
  	$query = "SELECT COUNT(1) IndexIsThere FROM INFORMATION_SCHEMA.STATISTICS WHERE table_schema=DATABASE() AND table_name='$table' AND index_name='$name'";
  	echo $query;
  	
  	
  	$list =  Yii::app()->db->createCommand($query)->queryColumn();
  	
  	var_dump($list[0]) ;
  	
  	return ($list[0] > 0);
  }
  
  
  public function createIndex($name, $table, $columns, $unique = false)
  {
  	if($this->indexExist($name, $table))
  		return true;
  	  	
  	parent::createIndex ($name, $table, $columns, $unique);
  	
  }
  
  public function dropIndex($name, $table)
  {
  	if(!$this->indexExist($name, $table))
  		return true;
  
  		parent::dropIndex ($name, $table);
  		 
  }
  /**
   * (non-PHPdoc)
   *
   * @see CDbMigration::addColumn()
   * @return boolean
   */
  public function dropColumn($table, $column)
  {
    if ($this->columnExists ( $table, $column ))
    {
      parent::dropColumn ( $table, $column );
      return true;
    }
    return false;
  }

  /**
   *
   * @param string $tableName          
   * @return CDbTableSchema
   */
  public function createTableIfNotExists($tableName)
  {
    $table = $this->getTable ( $tableName );
    if ($table == null)
    {
      $this->createTable ( $tableName, array (
          'id' => 'BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY',
          'epoch' => 'DATETIME' 
      ), 'ENGINE=MyISAM' );
      return $this->getTable ( $tableName );
    }
    else
    {
      return $table;
    }
  }
  
  public function createNonExistingTable($tableName, $columns, $options=NULL)
  {
      $table = $this->getTable ( $tableName );
      
	  if ($table == null)
	  {
	     $this->createTable ( $tableName, $columns, $options);
	  }
  }
  
  /**
   *
   * @param string $tableName          
   * @return CDbTableSchema
   */
  public function dropTableIfExists($tableName)
  {
    $table = $this->getTable ( $tableName );
    if ($table != null)
    {
      $this->dropTable ( $tableName );
      return true;
    }
    else
    {
      return false;
    }
  }

  /**
   *
   * @param string $triggerName          
   * @param string $targetTable          
   * @param string $when
   *          BEFORE | AFTER
   * @param string $on
   *          INSERT | UPDATE | DELETE }
   * @param string $script          
   * @return boolean
   */
  public function createTrigger($triggerName, $targetTable, $when, $on, $script)
  {
    $this->execute ( "
        CREATE TRIGGER $triggerName $when $on ON $targetTable
        FOR EACH ROW
        BEGIN
        $script
        ;
        END
        " );
  }

  public function dropTrigger($triggerName)
  {
    $this->execute ( "DROP TRIGGER IF EXISTS $triggerName" );
  }
}