<?php

class SimpleDelegator {

  public $target;

  public function __construct($object) {
    $this->target = $object;
  }

  public function __get($name) {
    $getter = 'get'.$name;
    if(method_exists($this,$getter))
      return $this->$getter();

    return $this->target->{$name};
  }

  public function __set($name, $value) {
    $setter = 'set'.$name;
    if (method_exists($this, $setter))
      return $this->$setter($value);

    return $this->target->{$name} = $value;
  }

  public function __call($name, $args) {
    return $this->target->{$name}($args);
  }
}
