<?php

class ViolationDocumentController extends Controller
{

  public $layout = '//layouts/column2';

  /**
   * Displays a particular model.
   *
   * @param integer $id
   *          the ID of the model to be displayed
   */
  public function actionView($id)
  {
    access_denied_check ( 'violation_document_view' );
    $this->render ( 'view', array (
        'model' => $this->loadModel ( $id ) 
    ) );
  }

  public function actionDownload($id)
  {
    access_denied_check ( 'violation_document_download' );
    $model = $this->loadModel ( $id );
    get_file_stream ( $model->getFinalSearchPath() );
  }

  /**
   * Creates a new model.
   * If creation is successful, the browser will be redirected to the 'view' page.
   */
  public function actionCreate()
  {
    access_denied_check ( 'violation_document_create' );
    $model = new ViolationDocument ();
    
    // Uncomment the following line if AJAX validation is needed
    // $this->performAjaxValidation($model);
    
    if (isset ( $_POST ['ViolationDocument'] ))
    {
      $model->attributes = $_POST ['ViolationDocument'];
      if ($model->save ())
        $this->redirect ( array (
            'view',
            'id' => $model->id 
        ) );
    }
    
    $this->render ( 'create', array (
        'model' => $model 
    ) );
  }

  /**
   * Updates a particular model.
   * If update is successful, the browser will be redirected to the 'view' page.
   *
   * @param integer $id
   *          the ID of the model to be updated
   */
  public function actionUpdate($id)
  {
    access_denied_check ( 'violation_document_update' );
    $model = $this->loadModel ( $id );
    
    // Uncomment the following line if AJAX validation is needed
    // $this->performAjaxValidation($model);
    
    if (isset ( $_POST ['ViolationDocument'] ))
    {
      $model->attributes = $_POST ['ViolationDocument'];
      if ($model->save ())
        $this->redirect ( array (
            'view',
            'id' => $model->id 
        ) );
    }
    
    $this->render ( 'update', array (
        'model' => $model 
    ) );
  }

  /**
   * Deletes a particular model.
   * If deletion is successful, the browser will be redirected to the 'admin' page.
   *
   * @param integer $id
   *          the ID of the model to be deleted
   */
  public function actionDelete($id)
  {
    access_denied_check ( 'violation_document_delete' );
    $this->loadModel ( $id )
      ->delete ();
    $this->redirectTo ( 'ViolationDocument/admin' );
  }

  /**
   * Lists all models.
   */
  public function actionIndex()
  {
    $this->redirectTo ( 'ViolationDocument/admin' );
  }

  /**
   * Manages all models.
   */
  public function actionAdmin()
  {
    access_denied_check ( 'violation_document_manage' );
    
    $model = new ViolationDocument ( 'search' );
    $model->unsetAttributes (); // clear any default values
    if (isset ( $_GET ['ViolationDocument'] ))
      $model->attributes = $_GET ['ViolationDocument'];
    
    $this->render ( 'admin', array (
        'model' => $model 
    ) );
  }

  /**
   * Returns the data model based on the primary key given in the GET variable.
   * If the data model is not found, an HTTP exception will be raised.
   *
   * @param
   *          integer the ID of the model to be loaded
   * @return ViolationDocument the model found
   */
  public function loadModel($id)
  {
    $model = ViolationDocument::model ()->findByPk ( $id );
    if ($model === null)
      throw new CHttpException ( 404, 'The requested page does not exist.' );
    return $model;
  }
}
