<?php

class m130204_135657_from_british_to_american_behavior extends MyDbMigration
{
	public function up()
	{

		if ($this->dbConnection->schema->getTable('behaviour') != null)
		
			$this->renameTable('behaviour', 'behavior');
		
		if ($this->dbConnection->schema->getTable('events_behaviour') != null)
		{
			$this->renameTable('events_behaviour', 'events_behavior');
			$this->renameColumn('events_behavior', 'id_behaviour', 'id_behavior');
		}
			
		
		if ($this->dbConnection->schema->getTable('gate_behaviour') != null)
		{
			$this->renameTable('gate_behaviour', 'gate_behavior');
			$this->renameColumn('gate_behavior', 'id_behaviour', 'id_behavior');
		}
		
		if (!$this->dbConnection->schema->getTable('violation_codes'))
		{
			$this->execute('
			
			CREATE TABLE  `eventserverdb`.`violation_codes` (
			`id` int(11) NOT NULL auto_increment,
			`name` varchar(255) NOT NULL,
			`id_behavior` int(11) NOT NULL,
			`description` text,
			`has_goods` tinyint(1) default NULL,
			PRIMARY KEY  (`id`)
			) ENGINE=MyISAM AUTO_INCREMENT=3321 DEFAULT CHARSET=latin1;'
			);
		}
		
		if ($this->dbConnection->schema->getTable('violation_codes')->getColumn('id_behaviour') != null)
			$this->renameColumn('violation_codes', 'id_behaviour', 'id_behavior');
    	
    return true;
	}

	public function down()
	{
    $this->renameTable('behavior', 'behaviour');
    $this->renameTable('events_behavior', 'events_behaviour');
    $this->renameTable('gate_behavior', 'gate_behaviour');

    $this->renameColumn('events_behaviour', 'id_behavior', 'id_behaviour');
    $this->renameColumn('gate_behaviour', 'id_behavior', 'id_behaviour');
    $this->renameColumn('violation_codes', 'id_behavior', 'id_behaviour');
    return true;
	}

}
