<?php

class m140414_083929_add_time_limit_to_time_table extends MyDbMigration
{
	public function up()
	{
		if ($this->dbConnection->schema->getTable('timetable')->getColumn('start_day') == null)
			$this->addColumn('timetable', 'start_day', 'TINYINT  DEFAULT null');

		if ($this->dbConnection->schema->getTable('timetable')->getColumn('start_month') == null)
			$this->addColumn('timetable', 'start_month', 'TINYINT  DEFAULT null');

		if ($this->dbConnection->schema->getTable('timetable')->getColumn('end_day') == null)
			$this->addColumn('timetable', 'end_day', 'TINYINT  DEFAULT null');
		
		if ($this->dbConnection->schema->getTable('timetable')->getColumn('end_month') == null)
			$this->addColumn('timetable', 'end_month', 'TINYINT  DEFAULT null');
		
		if ($this->dbConnection->schema->getTable('special_day'))
			$this->dropTable('special_day');
		
		$this->createTable('special_day',
				array(
			        'id' => 'pk',
			        'name' => 'string',
			        'description' => 'text',
			        'day' => 'integer',
      				'month' => 'integer',
      				'epoch' => 'datetime'
				),
				'ENGINE=MyISAM'
		);
		
		
	}

	public function down()
	{
		if ($this->dbConnection->schema->getTable('timetable')->getColumn('start_day') != null)
			$this->dropColumn('timetable', 'start_day');
		
		if ($this->dbConnection->schema->getTable('timetable')->getColumn('start_month') != null)
			$this->dropColumn('timetable', 'start_month');
		
		if ($this->dbConnection->schema->getTable('timetable')->getColumn('end_day') != null)
			$this->dropColumn('timetable', 'end_day');
		
		if ($this->dbConnection->schema->getTable('timetable')->getColumn('end_month') != null)
			$this->dropColumn('timetable', 'end_month');
		
		$this->dropTable('special_day');
		
		return true;
	}

	/*
	// Use safeUp/safeDown to do migration with transaction
	public function safeUp()
	{
	}

	public function safeDown()
	{
	}
	*/
}