<?php
class AlertSearchForm extends FormModel
{

	public $description = array();
	public $startDateTime;
	public $endDateTime;
	public $gates = array();
	public $types = array();
	public $bookmark;
	public $takenInChargeBy;
	public $closedBy;

	function __construct()
	{
	//	$this->startDateTime = new DateTime();
	//	$this->endDateTime   = new DateTime();
	}

	/**
	 * Declares attribute labels.
	 */
	public function myAttributeLabels()
	{
		return array(
				'description'=>t('Description'),
				'startDateTime'=>t('Start Date/Time'),
				'endDateTime'=>t('End Date/Time'),
				'gates'=>t('Gates'),
				'time'=>t('Schedule'),
		);
	}
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
				array('startDateTime, endDateTime', 'date', 'format'=>'yyyy-M-d H:m:s'),
				array('endDateTime','compare','compareAttribute'=>'startDateTime','operator'=>'>', 'allowEmpty'=>false,'message'=>'{attribute} must be greater than "{compareValue}".'),
				array('description, gates', 'array'),
				array('takenInChargeBy, closedBy', 'integer'),
				array('description, startDateTime, endDateTime, gates, types, takenInChargeBy, closedBy, bookmark', 'safe', 'on'=>'search'),
								
		);
	}

	public function getStartTimestamp()
	{
		return $this->startDateTime->getTimestamp();
	}
	public function getEndTimestamp()
	{
		return $this->endDateTime->getTimestamp();
	}
}