<?php

class EventsRepository extends CComponent
{
  /**
   * 
   * @var Event[]
   */
  private $events;

  /**
   * 
   * @param Event[] $events
   */
  public function __construct(array $events)
  {
    $this->events = $events;
  }

  /**
   * 
   * @return Event[]
   */
  public function getAll()
  {
    return $this->events;
  }

  /**
   * 
   * @return number
   */
  public function getCount()
  {
    return count($this->events);
  }

  /**
   * 
   * @return Event
   */
  public function getFirst()
  {
    if (isset($this->events) && count($this->events) > 0)
      return $this->events[0];
    return null;
  }

  /**
   * 
   * @return Event
   */
  public function getLast()
  {
    if (isset($this->events) && count($this->events) > 0)
      return $this->events[ count($this->events) - 1 ];
    return null;
  }
}
