<?php

/**
 * This is the model class for table "run_schedule".
 *
 * The followings are the available columns in table 'run_schedule':
 * @property string $ID
 * @property string $name
 * @property string $Description
 * @property integer $active
 * @property string $id_gate_group
 * @property string $id_time_table
 * @property integer $confirmation_required
 * @property Gate $gate
 * @property TimeSchedule $timeSchedule
 */
class RunSchedule extends ActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return RunSchedule the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'run_schedule';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('active, confirmation_required', 'numerical', 'integerOnly'=>true),
			array('name, Description', 'length', 'max'=>250),
			array('id_gate_group, id_time_table', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('ID, name, Description, active, id_gate_group, id_time_table, confirmation_required', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
      'gate'              => array(self::HAS_ONE, 'Gate',         'id_gate_group'),
      'timeSchedule'      => array(self::HAS_ONE, 'TimeSchedule', 'id_time_table'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function myAttributeLabels()
	{
		return array(
			'ID' => 'ID',
			'name' => t('Name'),
			'Description' => t('Description'),
			'active' => t('Active'),
			'id_gate_group' => t('Gate Group'),
			'id_time_table' => t('Time Schedule'),
			'confirmation_required' => t('Confirmation Required'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('ID',$this->ID,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('Description',$this->Description,true);
		$criteria->compare('active',$this->active);
		$criteria->compare('id_gate_group',$this->id_gate_group,true);
		$criteria->compare('id_time_table',$this->id_time_table,true);
		$criteria->compare('confirmation_required',$this->confirmation_required);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}