<?php

/**
 * This is the model class for table "abbonamentotable".
 *
 * The followings are the available columns in table 'abbonamentotable':
 * @property string $ID
 * @property string $Descrizione
 * @property string $Tipo
 * @property string $DataInizio
 * @property string $DataFine
 * @property string $Abilitato
 * @property string $Credito
 * @property string $Autorizzazione
 * @property string $UserID
 * @property string $epoch
 * @property string $Codice
 * @property integer $list_code
 * @property PlateList plate_list
 * @property VehicleOwner vehicleOwner
 * @property PlateAuthorization[] plateAuthorizations
 */
class ValidityPeriod extends ActiveRecord
{

  const ENABLE_BLACK = 0;

  const ENABLE_WHITE = 1;

  /**
   * Returns the static model of the specified AR class.
   *
   * @param string $className
   *          active record class name.
   * @return ValidityPeriod the static model class
   */
  public static function model($className = __CLASS__)
  {
    return parent::model ( $className );
  }

  /**
   *
   * @return string the associated database table name
   */
  public function tableName()
  {
    return 'abbonamentotable';
  }

  /**
   *
   * @return array validation rules for model attributes.
   */
  public function rules()
  {
    // NOTE: you should only define rules for those attributes that
    // will receive user inputs.
    return array (
        array (
            'list_code',
            'numerical',
            'integerOnly' => true 
        ),
        array (
            'Descrizione, Tipo, Codice',
            'length',
            'max' => 250 
        ),
        array (
            'Abilitato, Credito, Autorizzazione, UserID',
            'length',
            'max' => 20 
        ),
        array (
            'DataInizio, DataFine, epoch',
            'safe' 
        ),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array (
            'ID, Descrizione, Tipo, DataInizio, DataFine, Abilitato, Credito, Autorizzazione, UserID, epoch, Codice, list_code',
            'safe',
            'on' => 'search' 
        ) 
    );
  }

  public function behaviors()
  {
    return array (
        'edatetimebehavior' => array (
            'class' => 'ext.EDateTimeBehavior' 
        ) 
    );
  }

  /**
   *
   * @return array relational rules.
   */
  public function relations()
  {
    // NOTE: you may need to adjust the relation name and the related
    // class name for the relations automatically generated below.
    return array (
        'vehicleOwner' => array (
            self::BELONGS_TO,
            'VehicleOwner',
            'UserID' 
        ),
        'plateAuthorizations' => array (
            self::HAS_MANY,
            'PlateAuthorization',
            'AbbonamentoID' 
        ),
        'plate_list' => array (
            self::BELONGS_TO,
            'PlateList',
            array (
                'list_code' => 'code' 
            ) 
        ) 
    );
  }

  public function byDescription($what)
  {
    $this->getDbCriteria ()
      ->addCondition ( "(Descrizione LIKE '%$what%')" );
    
    return $this;
  }

  public function deleteByListCode($list_code)
  {
    ValidityPeriod::model ()->deleteAllByAttributes ( array (
        'list_code' => $list_code 
    ) );
  }

  /**
   *
   * @return array customized attribute labels (name=>label)
   */
  public function myAttributeLabels()
  {
    return array (
        'ID' => 'ID',
        'Descrizione' => t ( 'Description' ),
        'Tipo' => t ( 'Type' ),
        'DataInizio' => t ( 'Start date' ),
        'DataFine' => t ( 'End date' ),
        'Abilitato' => t ( 'Enabled' ),
        'Credito' => t ( 'Credit' ),
        'Autorizzazione' => t ( 'Authorization' ),
        'UserID' => t ( 'User' ),
        'epoch' => t ( 'Epoch' ),
        'Codice' => t ( 'Code' ),
        'list_code' => t ( 'List Code' ) 
    );
  }

  /**
   * Retrieves a list of models based on the current search/filter conditions.
   *
   * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
   */
  public function search()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.
    $criteria = new CDbCriteria ();
    
    $criteria->compare ( 'ID', $this->ID );
    $criteria->compare ( 'Descrizione', $this->Descrizione, true );
    $criteria->compare ( 'Tipo', $this->Tipo, true );
    $criteria->compare ( 'DataInizio', $this->DataInizio, true );
    $criteria->compare ( 'DataFine', $this->DataFine, true );
    $criteria->compare ( 'Abilitato', $this->Abilitato, true );
    $criteria->compare ( 'Credito', $this->Credito, true );
    $criteria->compare ( 'Autorizzazione', $this->Autorizzazione, true );
    $criteria->compare ( 'epoch', $this->epoch, true );
    $criteria->compare ( 'Codice', $this->Codice, true );
    
    $criteria->compare ( 'UserID', $this->UserID );
    $criteria->compare ( 'list_code', $this->list_code );
    
    return new CActiveDataProvider ( $this, array (
        'criteria' => $criteria 
    ) );
  }

  /**
   * Retrieves a list of models based on the current search/filter conditions.
   *
   * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
   */
  public function searchForWizard()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.
    $criteria = new CDbCriteria ();
    
    $criteria->compare ( 'Descrizione', $this->Descrizione, true );
    $criteria->compare ( 'UserID', $this->UserID );
    $criteria->compare ( 'list_code', $this->list_code );
    $criteria->compare ( 'Tipo', $this->Tipo, true );
    
    /*
     * $criteria->compare('ID',$this->ID,true);
     * $criteria->compare('DataInizio',$this->DataInizio,true);
     * $criteria->compare('DataFine',$this->DataFine,true);
     * $criteria->compare('Abilitato',$this->Abilitato,true);
     * $criteria->compare('Credito',$this->Credito,true);
     * $criteria->compare('Autorizzazione',$this->Autorizzazione,true);
     * $criteria->compare('epoch',$this->epoch,true);
     * $criteria->compare('Codice',$this->Codice,true);
     */
    
    return new CActiveDataProvider ( $this, array (
        'criteria' => $criteria 
    ) );
  }

  public static function getOrCreate(DateTimeEx $startDate, DateTimeEx $endDate, $userId, $list_code)
  {
    $validityPeriod = self::model()->find ( 'DataInizio=:di AND DataFine=:df AND UserID=:uid AND list_code=:lst', array (
        ':di' => $startDate,
        ':df' => $endDate,
        ':uid' => $userId,
        ':lst' => $list_code 
    ) );
    if ($validityPeriod == null)
    {
      $validityPeriod = new ValidityPeriod ();
      $validityPeriod->UserID = $userId;
      $validityPeriod->DataFine = $endDate;
      $validityPeriod->DataInizio = $startDate;
      $validityPeriod->list_code = $list_code;
      $validityPeriod->insert ();
    }
    return $validityPeriod;
  }
}