<?php

/**
 * This is the model class for table "usertable".
 *
 * The followings are the available columns in table 'usertable':
 * @property string $ID
 * @property string $Nome
 * @property string $Cognome
 * @property string $Note
 * @property string $ID1
 * @property string $ID2
 * @property string $Categoria
 * @property string $epoch
 * @property integer $list_code
 * @property string $email
 * @property string $address
 * @property string $city
 * @property string $phone
 */
class VehicleOwner extends ActiveRecord
{

  /**
   * Returns the static model of the specified AR class.
   *
   * @param string $className
   *          active record class name.
   * @return VehicleOwner the static model class
   */
  public static function model($className = __CLASS__)
  {
    return parent::model ( $className );
  }

  /**
   *
   * @return string the associated database table name
   */
  public function tableName()
  {
    return 'usertable';
  }

  /**
   *
   * @return array validation rules for model attributes.
   */
  public function rules()
  {
    // NOTE: you should only define rules for those attributes that
    // will receive user inputs.
    return array (
        array (
            'list_code',
            'numerical',
            'integerOnly' => true 
        ),
        array (
            'Nome, Cognome, Note',
            'length',
            'max' => 250 
        ),
        array (
            'ID1, ID2, Categoria',
            'length',
            'max' => 20 
        ),
        array (
            'epoch',
            'safe' 
        ),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array (
            'ID, Nome, Cognome, Note, ID1, ID2, Categoria, epoch, list_code',
            'safe',
            'on' => 'search' 
        ) 
    );
  }

  /**
   *
   * @return array relational rules.
   */
  public function relations()
  {
    // NOTE: you may need to adjust the relation name and the related
    // class name for the relations automatically generated below.
    return array (
        'plate_list' => array (
            self::BELONGS_TO,
            'PlateList',
            array (
                'list_code' => 'code' 
            ) 
        ),
        'vehicles' => array (
            self::HAS_MANY,
            'Vehicle',
            'UserID' 
        ),
        'validityPeriods' => array (
            self::HAS_MANY,
            'ValidityPeriod',
            'UserID' 
        ) 
    );
  }

  /**
   *
   * @return array customized attribute labels (name=>label)
   */
  public function myAttributeLabels()
  {
    return array (
        'ID' => 'ID',
        'Nome' => t ( 'Name' ),
        'Cognome' => t ( 'Surname' ),
        'Note' => t ( 'Note' ),
        'ID1' => 'Id1',
        'ID2' => 'Id2',
        'Categoria' => t ( 'Category' ),
        'epoch' => t ( 'Epoch' ),
        'email' => t ( 'Email' ),
        'address' => t ( 'Address' ),
        'city' => t ( 'City' ),
        'phone' => t ( 'Phone' ) 
    );
  }

  public function byDescription($what)
  {
    $this->getDbCriteria ()
      ->addCondition ( "(Nome LIKE '%$what%' OR Cognome LIKE '%$what%' OR CONCAT(Nome,' ',Cognome) LIKE '%$what%' OR CONCAT(Cognome,' ',Nome) LIKE '%$what%')" );
    
    return $this;
  }

  public function deleteByListCode($list_code)
  {
    VehicleOwner::model ()->deleteAllByAttributes ( array (
        'list_code' => $list_code 
    ) );
  }

  /**
   * Retrieves a list of models based on the current search/filter conditions.
   *
   * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
   */
  public function search()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.
    $criteria = new CDbCriteria ();
    
    $criteria->compare ( 'ID', $this->ID );
    $criteria->compare ( 'Nome', $this->Nome, true );
    $criteria->compare ( 'Cognome', $this->Cognome, true );
    $criteria->compare ( 'Note', $this->Note, true );
    $criteria->compare ( 'ID1', $this->ID1, true );
    $criteria->compare ( 'ID2', $this->ID2, true );
    $criteria->compare ( 'Categoria', $this->Categoria, true );
    $criteria->compare ( 'epoch', $this->epoch, true );
    $criteria->compare ( 'list_code', $this->list_code );
    
    return new CActiveDataProvider ( $this, array (
        'criteria' => $criteria 
    ) );
  }

  public function getFullName()
  {
    return "$this->Nome $this->Cognome";
  }

  /**
   *
   * @param string $name          
   * @param string $surname          
   * @return VehicleOwner
   */
  public static function findByName($name, $surname)
  {
    return self::model ()->find ( 'Nome=:nm AND Cognome=:cgnm', array (
        ':nm' => $name,
        ':cgnm' => $surname 
    ) );
  }

  /**
   *
   * @param string $name          
   * @param string $surname          
   * @return VehicleOwner[]
   */
  public static function findAllByName($name, $surname)
  {
    return self::model ()->findAll ( 'Nome=:nm AND Cognome=:cgnm', array (
        ':nm' => $name,
        ':cgnm' => $surname 
    ) );
  }

  public static function getOrCreate($name, $surname, $list_code)
  {
    $owner = self::model ()->find ( 'Nome=:nm AND Cognome=:cgnm AND list_code=:lst', array (
        ':nm' => $name,
        ':cgnm' => $surname,
        ':lst' => $list_code 
    ) );
    if ($owner == null)
    {
      $owner = new VehicleOwner ();
      $owner->Nome = $name;
      $owner->Cognome = $surname;
      $owner->list_code = $list_code;
      $owner->epoch = DateTimeEx::now ();
      $owner->insert ();
    }
    return $owner;
  }
}