<form <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'form-modal'), array('method', 'POST'), array('action', (absoluteUrl('service/startManual')))), 'html5', 'UTF-8'); ?>>
  <div class="modal-header">
    <button class="close" type="button" data-dismiss="modal" aria-hidden="true">
      &times;
    </button>
    <h3><?php echo htmlspecialchars(t("Start a task manually"),ENT_QUOTES,'UTF-8'); ?></h3>
  </div>
  <div class="modal-body">
    <label><?php echo htmlspecialchars(t('End time'),ENT_QUOTES,'UTF-8'); ?></label>
    <select <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'service-stop-time'), array('name', ('stopTime'))), 'html5', 'UTF-8'); ?>>
      <?php $stopTime = new DateTime(); ?>
      <?php DateHelper::roundToNearestMinutes($stopTime, 30); ?>
      <?php DateHelper::removeSeconds($stopTime); ?>
      <?php for($i=1; $i<=48; $i++) { ?>
        <?php $stopTime->modify("+30 minutes"); ?>
        <?php $label = DateHelper::format($stopTime, "EEEE, HH:mm"); ?>
        <option <?php echo MtHaml\Runtime::renderAttributes(array(array('value', ($stopTime->getTimestamp())), array('selected', ($i==24))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars($label,ENT_QUOTES,'UTF-8'); ?></option>
      <?php } ?>
      <option <?php echo MtHaml\Runtime::renderAttributes(array(array('value', ('-1'))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t('Unlimited'),ENT_QUOTES,'UTF-8'); ?></option>
    </select>
  </div>
  <div class="modal-footer">
    <button class="btn" type="button" data-dismiss="modal" aria-hidden="true"><?php echo htmlspecialchars(Yii::t('app', 'Close'),ENT_QUOTES,'UTF-8'); ?></button>
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'gateGroupId'), array('value', ($gateGroup->ID))), 'html5', 'UTF-8'); ?> />
    <button class="btn btn-primary" type="submit"><?php echo htmlspecialchars(t('Start task'),ENT_QUOTES,'UTF-8'); ?></button>
  </div>
</form>
