<?php $vehicleTypes = array('Truck', 'Vehicle', 'Motorcycle', 'Bus', 'Kemler'); ?>
<?php $countryList = CountryList::getCountryName(Event::getNationCodesList()); ?>
<form id="export-image-form">
  <div class="controls">
    <h4>
      <i class="icon-time"></i>
      <?php echo htmlspecialchars(t('When'),ENT_QUOTES,'UTF-8'); ?>
      <small><?php echo htmlspecialchars(t('Choose a date range'),ENT_QUOTES,'UTF-8'); ?></small>
    </h4>
    <div class="btn-group" id="when-buttons">
      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DatePickSetter')), array('data-datepick-setter-range', ('7')), array('data-datepick-setter-start-target', '#datepicker-start-date'), array('data-datepick-setter-end-target', '#datepicker-end-date')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t('Last 7 days'),ENT_QUOTES,'UTF-8'); ?></button>
      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DatePickSetter')), array('data-datepick-setter-range', ('30')), array('data-datepick-setter-start-target', '#datepicker-start-date'), array('data-datepick-setter-end-target', '#datepicker-end-date')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t('Last 30 days'),ENT_QUOTES,'UTF-8'); ?></button>
    </div>
  </div>
  <div class="controls">
    <div class="input-prepend input-append">
      <span class="add-on"><?php echo htmlspecialchars(t('From'),ENT_QUOTES,'UTF-8'); ?></span>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'datepicker-start-date'), array('class', ('date-picker' . ' ' . 'span2')), array('type', ('text')), array('value', ('')), array('readonly', ('true'))), 'html5', 'UTF-8'); ?> />
      <input id="start-timestamp" type="hidden" name="startTimestamp" />
      <span class="add-on icon-calendar"></span>
    </div>
    <div class="input-prepend input-append">
      <span class="add-on"><?php echo htmlspecialchars(t('To'),ENT_QUOTES,'UTF-8'); ?></span>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'datepicker-end-date'), array('class', ('date-picker' . ' ' . 'span2')), array('type', ('text')), array('value', ('')), array('readonly', ('true'))), 'html5', 'UTF-8'); ?> />
      <input id="end-timestamp" type="hidden" name="endTimestamp" />
      <span class="add-on icon-calendar"></span>
    </div>
    <div class="controls">
      <div id="datepicker-start-time" class="input-prepend input-append time-picker" data-time="00:00">
        <span class="add-on"><?php echo htmlspecialchars(t('From'),ENT_QUOTES,'UTF-8'); ?></span>
        <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'span1'), array('data-format', (Yii::app()->params['timeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'startTime'), array('data-time', '00:00'), array('value', '00:00')), 'html5', 'UTF-8'); ?> />
        <span class="add-on">
          <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
        </span>
      </div>
      <div id="datepicker-end-time" class="input-prepend input-append time-picker">
        <span class="add-on"><?php echo htmlspecialchars(t('To'),ENT_QUOTES,'UTF-8'); ?></span>
        <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'span1'), array('data-format', (Yii::app()->params['timeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'endTime'), array('value', '23:59')), 'html5', 'UTF-8'); ?> />
        <span class="add-on">
          <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
        </span>
      </div>
    </div>
  </div>
  <hr />
  <div class="controls">
    <h4>
      <i class="icon-map-marker"></i>
      <?php echo htmlspecialchars(t('Where'),ENT_QUOTES,'UTF-8'); ?>
      <small><?php echo htmlspecialchars(t('Gates'),ENT_QUOTES,'UTF-8'); ?></small>
      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini')), array('type', ('button')), array('data-behavior', ('CheckboxMaster')), array('data-checkbox-master-btngroup-target', '#gates')), 'html5', 'UTF-8'); ?>>
        <i class="icon-check"></i>
      </button>
    </h4>
    <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'gates'), array('class', 'btn-group'), array('data-toggle', ('buttons-checkbox'))), 'html5', 'UTF-8'); ?>>
      <?php $gtcnt = 0; ?>
      <?php foreach($gates as $gate) { ?>
        <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-gate')), array('type', ('button'))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars("{$gate->short_name}",ENT_QUOTES,'UTF-8'); ?>
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', ('checkbox')), array('name', ('gates[]')), array('value', ($gate->Gate))), 'html5', 'UTF-8'); ?> />
        </button>
        <?php if(++$gtcnt % 2 == 0) { ?>
          <br />
        <?php } ?>
      <?php } ?>
    </div>
  </div>
  <hr />
  <div class="controls">
    <h4>
      <i class="icon-truck"></i>
      <?php echo htmlspecialchars(t('What'),ENT_QUOTES,'UTF-8'); ?>
      <small><?php echo htmlspecialchars(t('Vehicle Type'),ENT_QUOTES,'UTF-8'); ?></small>
      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini')), array('type', ('button')), array('data-behavior', ('CheckboxMaster')), array('data-checkbox-master-btngroup-target', '#vehicles')), 'html5', 'UTF-8'); ?>>
        <i class="icon-check"></i>
      </button>
    </h4>
    <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'vehicles'), array('class', 'btn-group'), array('data-toggle', ('buttons-checkbox'))), 'html5', 'UTF-8'); ?>>
      <?php $vtcnt = 0; ?>
      <?php foreach ($vehicleTypes as $vehicleType) { ?>
        <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button'))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(t($vehicleType),ENT_QUOTES,'UTF-8'); ?>
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', ('checkbox')), array('name', 'vehiclesClass[]'), array('value', $vehicleType)), 'html5', 'UTF-8'); ?> />
        </button>
        <?php if(++$vtcnt % 4 == 0) { ?>
          <br />
        <?php } ?>
      <?php } ?>
    </div>
  </div>
  <hr />
  <div class="controls">
    <h4>
      <i class="icon-flag"></i>
      <?php echo htmlspecialchars(t('From Where'),ENT_QUOTES,'UTF-8'); ?>
      <small><?php echo htmlspecialchars(t('Nationality'),ENT_QUOTES,'UTF-8'); ?></small>
      <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini')), array('type', ('button')), array('data-behavior', ('CheckboxMaster')), array('data-checkbox-master-btngroup-target', '#nationalities')), 'html5', 'UTF-8'); ?>>
        <i class="icon-check"></i>
      </button>
    </h4>
    <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'nationalities'), array('class', 'btn-group'), array('data-toggle', ('buttons-checkbox'))), 'html5', 'UTF-8'); ?>>
      <?php $vtcnt = 0; ?>
      <?php foreach ($countryList as $country) { ?>
        <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button'))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(t($country['nation']),ENT_QUOTES,'UTF-8'); ?>
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', ('checkbox')), array('name', 'Nationalities[]'), array('value', ($country['iso_code']))), 'html5', 'UTF-8'); ?> />
        </button>
        <?php if(++$vtcnt % 4 == 0) { ?>
          <br />
        <?php } ?>
      <?php } ?>
    </div>
  </div>
  <hr />
  <div class="controls">
    <h4>
      <i class="icon-id-card"></i>
      <?php echo htmlspecialchars(t('Plate'),ENT_QUOTES,'UTF-8'); ?>
      <small><?php echo htmlspecialchars(t('License Plate'),ENT_QUOTES,'UTF-8'); ?></small>
    </h4>
    <span2>
      <input id="limit" class="span3" type="text" name="plate" />
    </span2>
  </div>
  <hr />
  <div class="controls">
    <h4>
      <i class="icon-dashboard"></i>
      <?php echo htmlspecialchars(t('Speed'),ENT_QUOTES,'UTF-8'); ?>
    </h4>
    <div id="slider-range"></div>
    <div class="form-inline controls">
      <div class="input-prepend input-append">
        <span class="add-on">
          <?php echo htmlspecialchars(t('Min'),ENT_QUOTES,'UTF-8'); ?>
        </span>
        <input id="min-speed" class="span1" type="text" name="minSpeed" readonly="readonly" />
        <span class="add-on">
          Km/h
        </span>
      </div>
      <div class="input-prepend input-append">
        <span class="add-on">
          <?php echo htmlspecialchars(t('Max'),ENT_QUOTES,'UTF-8'); ?>
        </span>
        <input id="max-speed" class="span1" type="text" name="maxSpeed" readonly="readonly" />
        <span class="add-on">
          Km/h
        </span>
      </div>
    </div>
  </div>
  <hr />
  <div class="controls">
    <h4>
      <i class="icon-dashboard"></i>
      <?php echo htmlspecialchars(t('Conditions'),ENT_QUOTES,'UTF-8'); ?>
    </h4>
    <span class="add-on span3">
      <?php echo htmlspecialchars(t('Modified plates only'),ENT_QUOTES,'UTF-8'); ?>
    </span>
    <input id="plate-changed" class="span1" type="checkbox" name="plateChanged" value="1" />
    <span class="add-on span3">
      <?php echo htmlspecialchars(t('Modified nationality only'),ENT_QUOTES,'UTF-8'); ?>
    </span>
    <input id="natonality-changed" class="span1" type="checkbox" name="nationalityChanged" value="1" />
    <span class="add-on span3">
      <?php echo htmlspecialchars(t('Modified class only'),ENT_QUOTES,'UTF-8'); ?>
    </span>
    <input id="class-changed" class="span1" type="checkbox" name="classChanged" value="1" />
    <span class="add-on span3">
      <?php echo htmlspecialchars(t('Discarged only'),ENT_QUOTES,'UTF-8'); ?>
    </span>
    <input id="class-changed" class="span1" type="checkbox" name="discargedOnly" value="1" />
  </div>
  <hr />
  <div class="controls">
    <h4>
      <i class="icon-list-ol"></i>
      <?php echo htmlspecialchars(t('How Many'),ENT_QUOTES,'UTF-8'); ?>
      <small><?php echo htmlspecialchars(t('max num of events'),ENT_QUOTES,'UTF-8'); ?></small>
    </h4>
    <span4>
      <span class="add-on">
        <?php echo htmlspecialchars(t('max'),ENT_QUOTES,'UTF-8'); ?>
      </span>
      <input id="limit" class="span1" type="number" name="eventsLimit" value="10" />
      <span class="add-on">
        <?php echo htmlspecialchars(t('num. of events'),ENT_QUOTES,'UTF-8'); ?>
      </span>
    </span4>
  </div>
  <div class="controls">
    <button class="btn" type="submit"><?php echo htmlspecialchars(t('List'),ENT_QUOTES,'UTF-8'); ?></button>
    <button class="btn" type="export"><?php echo htmlspecialchars(t('Export'),ENT_QUOTES,'UTF-8'); ?></button>
  </div>
</form>
