<?php $nationality = $event->custom_nationality; ?>
<?php if (isEmpty ( $nationality )) { ?>
  <?php if (paramdeep ( 'events', 'nationality', 'default' ) !== false) { ?>
    <?php $nationality = paramdeep ( 'events', 'nationality', 'default' );; ?>
  <?php } ?>
<?php } ?>
<?php $isWhitelist = false; ?>
<?php foreach ($event->gate->gateBehavior as $index => $gateBehavior) { ?>
  <?php if($gateBehavior->is_whitelist) { ?>
    <?php $isWhitelist = true; ?>
  <?php } ?>
<?php } ?>
<div id="alert-view">
  <div class="page-header">
    <div class="row clearfix">
      <div class="span8">
        <h2>
          <?php echo htmlspecialchars(t('Event detail'),ENT_QUOTES,'UTF-8'); ?>
        </h2>
      </div>
      <div class="span2 pull-right text-right">
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('href', (Yii::app()->createAbsoluteUrl('alert/ExportPdfEvent', array('id' => $event->ID)))), array('target', ('_blank'))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(t('Export'),ENT_QUOTES,'UTF-8'); ?>
        </a>
      </div>
    </div>
  </div>
  <div class="row">
    <div class="span4">
      <div id="videos">
        <?php if(Yii::app()->user->checkAccess('media_view_video')) { ?>
          <?php foreach($event->videos as $video) { ?>
            <?php $this->renderVideo($video->url,370); ?>
          <?php } ?>
        <?php } ?>
      </div>
      <div id="etalage-container" data-behavior="MediaEtalage">
        <?php if(Yii::app()->user->checkAccess('media_view_photo')) { ?>
          <ul id="etalage">
            <?php foreach ($event->photos as $photo) { ?>
              <li>
                <?php if (!Yii::app()->user->checkAccess('edit_event_behaviors')) { ?>
                  <?php if(paramdeep('media','enableEnhancedMode')) { ?>
                    <?php $footer = $photo->getFooterRectangle(); ?>
                    <?php if (isset($footer)) { ?>
                      <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'footer'), array('data-rect-top', ($footer->topLeft->y)), array('data-rect-left', ($footer->topLeft->x)), array('data-rect-height', ($footer->height)), array('data-rect-width', ($footer->width)), array('data-image-height', ($photo->height)), array('data-image-width', ($photo->width))), 'html5', 'UTF-8'); ?>></div>
                    <?php } ?>
                    <?php $plate = $photo->getPlateRectangle(); ?>
                    <?php if (isset($plate)) { ?>
                      <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'plate'), array('data-rect-top', ($plate->topLeft->y)), array('data-rect-left', ($plate->topLeft->x)), array('data-rect-height', ($plate->height)), array('data-rect-width', ($plate->width)), array('data-image-height', ($photo->height)), array('data-image-width', ($photo->width)), array('data-plate-hide', '0')), 'html5', 'UTF-8'); ?>></div>
                    <?php } ?>
                    <?php $areas = $photo->getExtraAreas(); ?>
                    <?php if (isset($areas) && count($areas) > 0)     { ?>
                      <div class="extra-areas">
                        <?php foreach($areas as $areaType => $areaGroup) { ?>
                          <?php foreach($areaGroup as $area) { ?>
                            <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'extra-area'), array('data-type', $areaType), array('data-rect-top', ($area->topLeft->y)), array('data-rect-left', ($area->topLeft->x)), array('data-rect-height', ($area->height)), array('data-rect-width', ($area->width)), array('data-image-height', ($photo->height)), array('data-image-width', ($photo->width)), array('data-plate-hide', '0'), array('data-border-color', (ImageAreaHelper::getAreaColor($areaType)))), 'html5', 'UTF-8'); ?>></div>
                          <?php } ?>
                        <?php } ?>
                      </div>
                    <?php } ?>
                  <?php } ?>
                <?php } ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($photo->url))), 'html5', 'UTF-8'); ?>>
                  <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'etalage_source_image'), array('src', ($photo->url))), 'html5', 'UTF-8'); ?> />
                </a>
              </li>
            <?php } ?>
          </ul>
        <?php } ?>
      </div>
    </div>
    <div class="span8">
      <div id="event-data">
        <div class="row">
          <div class="span4">
            <fieldset>
              <?php $this->renderPartial('/alert/_eventDetails', array('event' => $event)); ?>
            </fieldset>
          </div>
        </div>
        <?php if($isWhitelist) { ?>
          <div class="row">
            <div class="span8">
              <?php $this->renderParti al("/event/_eventBehavior_WhiteList_SmartTips", $vars); ?>
            </div>
          </div>
        <?php } ?>
        <?php if(false && user()->checkAccess('show_event_violation_document')) { ?>
          <?php foreach ($event->eventBehaviors as $eventBehavior) { ?>
            <?php foreach ($eventBehavior->violationDocuments as $violationDocument) { ?>
              <?php echo htmlspecialchars('Violation document = '.$violationDocument->id,ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          <?php } ?>
        <?php } ?>
      </div>
    </div>
  </div>
</div>
