<div id="time-schedule-index-page">
  <div class="page-header">
    <h2>
      <li class="icon-cog"></li>
      <?php echo htmlspecialchars(Yii::t("app", "Time Schedules"),ENT_QUOTES,'UTF-8'); ?>
    </h2>
  </div>
  <div class="row">
    <?php $timeSchedules = $dataProvider->data; ?>
    <div class="tableContainer pagination-data-container">
      <table class="table span12">
        <thead>
          <tr></tr>
          <tr>
            <th></th>
            <th><?php echo htmlspecialchars(t('ID'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Description'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Start Date'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('End Date'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Creation date'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('For tasks'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('For plate authorizations'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('For ZTL'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('In use'),ENT_QUOTES,'UTF-8'); ?></th>
            <th>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini')), array('href', (Yii::app()->createAbsoluteUrl('timeSchedule/create')))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(Yii::t('app', 'New time schedule')   ,ENT_QUOTES,'UTF-8'); ?>
              </a>
            </th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($timeSchedules as $index => $timeSchedule) { ?>
            <tr>
              <td>
                <?php echo $timeSchedule->getIconTagFinal(); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($timeSchedule->ID,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo SystemInfoHelper::getTimeScheduleCoolName($timeSchedule->ID); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($timeSchedule->start_day,ENT_QUOTES,'UTF-8'); ?>
                <?php echo htmlspecialchars(DateHelper::getMonthName($timeSchedule->start_month),ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($timeSchedule->end_day,ENT_QUOTES,'UTF-8'); ?>
                <?php echo htmlspecialchars(DateHelper::getMonthName($timeSchedule->end_month),ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars(DateHelper::formatMedium($timeSchedule->epoch),ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('TimeSchedule/SwitchParam', array('id'=>$timeSchedule->ID, 'param'=>'for_run'))))), 'html5', 'UTF-8'); ?>>
                  <?php if($timeSchedule->for_run) { ?>
                    <div class="icon-check"></div>
                  <?php } else { ?>
                    <div class="icon-check-empty"></div>
                  <?php } ?>
                </a>
              </td>
              <td>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('TimeSchedule/SwitchParam', array('id'=>$timeSchedule->ID, 'param'=>'for_whitelisttable'))))), 'html5', 'UTF-8'); ?>>
                  <?php if($timeSchedule->for_whitelisttable) { ?>
                    <div class="icon-check"></div>
                  <?php } else { ?>
                    <div class="icon-check-empty"></div>
                  <?php } ?>
                </a>
              </td>
              <td>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('TimeSchedule/SwitchParam', array('id'=>$timeSchedule->ID, 'param'=>'for_ztl'))))), 'html5', 'UTF-8'); ?>>
                  <?php if($timeSchedule->for_ztl) { ?>
                    <div class="icon-check"></div>
                  <?php } else { ?>
                    <div class="icon-check-empty"></div>
                  <?php } ?>
                </a>
              </td>
              <td>
                <?php if($timeSchedule->IsInUse) { ?>
                  <div class="icon-check"></div>
                <?php } else { ?>
                  <div class="icon-check-empty"></div>
                <?php } ?>
              </td>
              <td>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-pencil'), array('href', (Yii::app()->createUrl('timeSchedule/update', array('id' => $timeSchedule->ID))))), 'html5', 'UTF-8'); ?>></a>
                <?php if(!$timeSchedule->IsInUse) { ?>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-trash'), array('href', (Yii::app()->createUrl('timeSchedule/delete', array('id' => $timeSchedule->ID))))), 'html5', 'UTF-8'); ?>></a>
                <?php } ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('show-hide-details-button' . ' ' . 'icon-plus')), array('data-details-id', ('time-schedule-details-' . $index))), 'html5', 'UTF-8'); ?>></a>
              </td>
            </tr>
            <tr <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'time-schedule-details'), array('id', ('time-schedule-details-' . $index)), array('style', 'display:none')), 'html5', 'UTF-8'); ?>>
              <td></td>
              <td COLSPAN="5">
                <?php $this->renderPartial('_timeSlotsDetails', array('timeSchedule'=>$timeSchedule)); ?>
              </td>
            </tr>
          <?php } ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
