<?php $currentUrl = Yii::app()->createAbsoluteUrl($this->route,$context); ?>
<?php $hasData = isset($auths) && count($auths->data)>0; ?>
<?php $types = paramdeep('plateAuthorizations','types'); ?>
<?php $gates = array('-1' => t('Every gate')) + PlateAuthorizationController::getGateObjects(); ?>
<?php $times = array('-1' => t('Always')) + TimeSchedule::getTimeScheduleArrayForPlateAuths(); ?>
<?php if(!array_key_exists(paramdeep('plateAuthorizations','default','plateAuthType'),$types)) { ?>
  <?php $types[paramdeep('plateAuthorizations','default','plateAuthType')] = paramdeep('plateAuthorizations','default','plateAuthType'); ?>
<?php } ?>
<?php if(!array_key_exists(paramdeep('plateAuthorizations','default','time'),$times)) { ?>
  <?php $times[paramdeep('plateAuthorizations','default','time')] = paramdeep('plateAuthorizations','default','time'); ?>
<?php } ?>
<?php if(!array_key_exists(paramdeep('plateAuthorizations','default','gate'),$gates)) { ?>
  <?php $gates[paramdeep('plateAuthorizations','default','gate')] = paramdeep('plateAuthorizations','default','gate'); ?>
<?php } ?>
<div class="page-header">
  <h2>
    <i class="icon-ok-circle"></i>
    <?php echo htmlspecialchars(t('Plate authorizations'),ENT_QUOTES,'UTF-8'); ?>
  </h2>
</div>
<h5>
  <?php $navigate_url_list = Yii::app()->createAbsoluteUrl('plateAuthorization'); ?>
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $navigate_url_list)), 'html5', 'UTF-8'); ?>>
    <i class="icon-file-text-alt"></i>
    <?php echo htmlspecialchars($objList->name,ENT_QUOTES,'UTF-8'); ?>
  </a>
  <?php $navigate_url_user = Yii::app()->createAbsoluteUrl($this->route,array('plateListId'=>$plateListId,'step'=>'1')); ?>
  <i class="icon-long-arrow-right"></i>
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $navigate_url_user)), 'html5', 'UTF-8'); ?>>
    <i class="icon-user"></i>
    <?php echo htmlspecialchars("$objOwner->Nome $objOwner->Cognome",ENT_QUOTES,'UTF-8'); ?>
  </a>
  <?php $navigate_url_vehicle = Yii::app()->createAbsoluteUrl($this->route,array('plateListId'=>$plateListId,'step'=>'2','ownerId'=>$ownerId)); ?>
  <i class="icon-long-arrow-right"></i>
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $navigate_url_vehicle)), 'html5', 'UTF-8'); ?>>
    <i class="icon-truck"></i>
    <?php echo htmlspecialchars($objVehicle->Targa,ENT_QUOTES,'UTF-8'); ?>
  </a>
  <?php $navigate_url_period = Yii::app()->createAbsoluteUrl($this->route,array('plateListId'=>$plateListId,'step'=>'3','ownerId'=>$ownerId,'vehicleId'=>$vehicleId)); ?>
  <i class="icon-long-arrow-right"></i>
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $navigate_url_period)), 'html5', 'UTF-8'); ?>>
    <i class="icon-time"></i>
    <?php echo htmlspecialchars($objPeriod->Descrizione,ENT_QUOTES,'UTF-8'); ?>
  </a>
  <i class="icon-long-arrow-right"></i>
  <i class="icon-ok-circle"></i>
  <?php echo htmlspecialchars(t('Select plate authorization'),ENT_QUOTES,'UTF-8'); ?>
</h5>
<?php $goback_url = Yii::app()->createAbsoluteUrl($this->route,array('plateListId'=>$plateListId,'step'=>'3','ownerId'=>$ownerId,'vehicleId'=>$vehicleId)); ?>
<div class="row">
  <div class="form-box">
    <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',      array('id'=>'validityperiod-search-form','action' => Yii::app()->createUrl($this->route),'method' => 'GET',)); ?>
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'plateListId'), array('value', $plateListId)), 'html5', 'UTF-8'); ?> />
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'ownerId'), array('value', $ownerId)), 'html5', 'UTF-8'); ?> />
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'vehicleId'), array('value', $vehicleId)), 'html5', 'UTF-8'); ?> />
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'validityPeriodId'), array('value', $validityPeriodId)), 'html5', 'UTF-8'); ?> />
    <input type="hidden" name="step" value="4" />
    <input type="hidden" name="action" value="search" />
    <h3>
      <?php echo htmlspecialchars(t("Plate authorizations list"),ENT_QUOTES,'UTF-8'); ?>
    </h3>
    <?php $this->endWidget(); ?>
    <?php if ($hasData) { ?>
      <div class="tableContainer pagination-data-container">
        <table class="table table-condensed">
          <thead>
            <tr>
              <th></th>
              <th><?php echo htmlspecialchars(PlateAuthorization::model()->getAttributeLabel('Descrizione'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(PlateAuthorization::model()->getAttributeLabel('GateID'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(PlateAuthorization::model()->getAttributeLabel('TimeID'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(PlateAuthorization::model()->getAttributeLabel('type'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(PlateAuthorization::model()->getAttributeLabel('epoch'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(t('Status'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(t('Submitted by'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(t('Actions'),ENT_QUOTES,'UTF-8'); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($auths->data as $plateAuth)               { ?>
              <?php $da = new DateTime();; ?>
              <?php $a = $plateAuth->validityPeriod->DataFine;; ?>
              <?php $diff = $da->diff($a);; ?>
              <?php $expired = ($diff->format('%R') == '-');; ?>
              <?php $item_url = Yii::app()->createUrl('plateAuthorization/'.$plateAuth->ID, array('fromWizard'=>1)); ?>
              <?php $delete_url = Yii::app()->createUrl('plateAuthorization/whiteListWizardDelete',array('listId'=>$plateListId, 'objType'=>'auth', 'objId'=>$plateAuth->ID, 'returnUrl'=>$currentUrl)); ?>
              <?php $renew_url = Yii::app()->createUrl('plateAuthorization/renew',array('plateAuthId'=>$plateAuth->ID, 'returnUrl'=>$currentUrl)); ?>
              <?php $revoke_url = Yii::app()->createUrl('plateAuthorization/revoke',array('plateAuthId'=>$plateAuth->ID, 'returnUrl'=>$currentUrl)); ?>
              <?php $enable_url = Yii::app()->createUrl('plateAuthorization/activate',array('plateAuthId'=>$plateAuth->ID, 'returnUrl'=>$currentUrl)); ?>
              <?php $confirm_url = Yii::app()->createUrl('plateAuthorization/confirm',array('plateAuthId'=>$plateAuth->ID, 'returnUrl'=>$currentUrl)); ?>
              <?php $print_url = Yii::app()->createUrl('plateAuthorization/print',array('id'=>$plateAuth->ID)); ?>
              <tr>
                <td>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $item_url), array('title', (t('View')))), 'html5', 'UTF-8'); ?>>
                    <i class="icon-eye-open"></i>
                  </a>
                </td>
                <td>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $item_url)), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars($plateAuth->Descrizione,ENT_QUOTES,'UTF-8'); ?></a>
                </td>
                <td>
                  <?php echo SystemInfoHelper::getPlateAuthGateCoolName($plateAuth->GateID,$plateAuth->GateID_type); ?>
                </td>
                <td>
                  <?php echo SystemInfoHelper::getTimeScheduleCoolName($plateAuth->TimeID); ?>
                </td>
                <td>
                  <?php echo htmlspecialchars($types[$plateAuth->type],ENT_QUOTES,'UTF-8'); ?>
                </td>
                <td>
                  <?php echo htmlspecialchars($plateAuth->epoch,ENT_QUOTES,'UTF-8'); ?>
                </td>
                <td>
                  <?php if($plateAuth->to_be_confirmed) { ?>
                    <?php echo htmlspecialchars(t('To be confirmed'),ENT_QUOTES,'UTF-8'); ?>
                  <?php } else if($plateAuth->enabled != 1) { ?>
                    <?php echo htmlspecialchars(t('Disabled'),ENT_QUOTES,'UTF-8'); ?>
                  <?php } else if($expired) { ?>
                    <?php echo htmlspecialchars(t('Expired'),ENT_QUOTES,'UTF-8'); ?>
                  <?php } else { ?>
                    <?php echo htmlspecialchars(t('Activated'),ENT_QUOTES,'UTF-8'); ?>
                  <?php } ?>
                </td>
                <td>
                  <?php if(Yii::app()->user->checkAccess('user_view') && $plateAuth->insertid>0) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('user/'.$plateAuth->insertid)))), 'html5', 'UTF-8'); ?>>
                      <i>
                        <?php echo htmlspecialchars($plateAuth->getSubmitter(),ENT_QUOTES,'UTF-8'); ?>
                      </i>
                    </a>
                  <?php } else { ?>
                    <i>
                      <?php echo htmlspecialchars($plateAuth->getSubmitter(),ENT_QUOTES,'UTF-8'); ?>
                    </i>
                  <?php } ?>
                </td>
                <td>
                  <?php $this->printPrintBtn($plateAuth); ?>
                  <?php if(Yii::app()->user->checkAccess('plate_auth_enable')) { ?>
                    <?php if($plateAuth->enabled == 1) { ?>
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $revoke_url), array('title', (t('Revoke')))), 'html5', 'UTF-8'); ?>>
                        <i class="icon-stop"></i>
                      </a>
                    <?php } else { ?>
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $enable_url), array('title', (t('Activate')))), 'html5', 'UTF-8'); ?>>
                        <i class="icon-play"></i>
                      </a>
                    <?php } ?>
                  <?php } ?>
                  <?php if($plateAuth->to_be_confirmed == 1 && Yii::app()->user->checkAccess('plate_auth_confirmed')) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $confirm_url), array('title', (t('Confirm')))), 'html5', 'UTF-8'); ?>>
                      <i class="icon-unlock-alt"></i>
                    </a>
                  <?php } ?>
                  <?php if(Yii::app()->user->checkAccess('plate_auth_renew')) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $renew_url), array('title', (t('Renew')))), 'html5', 'UTF-8'); ?>>
                      <i class="icon-repeat"></i>
                    </a>
                  <?php } ?>
                  <?php if(Yii::app()->user->checkAccess('plate_auth_delete')) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $delete_url), array('title', (t('Delete'))), array('onclick', ('return confirm(\'' . (t('Are you sure you want to delete this item?')) . '\')'))), 'html5', 'UTF-8'); ?>>
                      <i class="icon-trash"></i>
                    </a>
                  <?php } ?>
                </td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
      <?php if (isset($auths->pagination)) { ?>
        <div class="pagination pagination-links-container">
          <?php $this->widget('bootstrap.widgets.TbPager', array('pages' => $auths->pagination)); ?>
        </div>
      <?php } ?>
    <?php } else { ?>
      <h4><?php echo htmlspecialchars(Yii::t("app", "No results"),ENT_QUOTES,'UTF-8'); ?></h4>
    <?php } ?>
  </div>
</div>
<?php if(true) { ?>
  <br />
  <div class="row">
    <div class="form-box">
      <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',      array('id'=>'validityperiod-create-form','action' => Yii::app()->createUrl($this->route),'method' => 'POST',)); ?>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'plateListId'), array('value', $plateListId)), 'html5', 'UTF-8'); ?> />
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'ownerId'), array('value', $ownerId)), 'html5', 'UTF-8'); ?> />
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'vehicleId'), array('value', $vehicleId)), 'html5', 'UTF-8'); ?> />
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'validityPeriodId'), array('value', $validityPeriodId)), 'html5', 'UTF-8'); ?> />
      <input type="hidden" name="step" value="4" />
      <input type="hidden" name="action" value="create" />
      <h3><?php echo htmlspecialchars(t("Create plate authorization"),ENT_QUOTES,'UTF-8'); ?></h3>
      <h5><?php echo htmlspecialchars(PlateAuthorization::model()->getAttributeLabel('Descrizione'),ENT_QUOTES,'UTF-8'); ?></h5>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', 'p_description'), array('value', (paramdeep('plateAuthorizations','default','plateAuthDescription')))), 'html5', 'UTF-8'); ?> />
      <?php echo htmlspecialchars(t("(for example: 'Harry Potter, FIAT Panda, July 2012')"),ENT_QUOTES,'UTF-8'); ?>
      <h5>
        <?php echo htmlspecialchars(PlateAuthorization::model()->getAttributeLabel('type'),ENT_QUOTES,'UTF-8'); ?>
        <font color="red"><?php echo htmlspecialchars('*',ENT_QUOTES,'UTF-8'); ?></font>
      </h5>
      <?php echo CHtml::dropDownList('p_type', paramdeep('plateAuthorizations','default','plateAuthType'), $types, array('class'=>'span2  chzn-select', 'data-placeholder' => Yii::t('app', 'Type...')));; ?>
      <h5>
        <?php echo htmlspecialchars(PlateAuthorization::model()->getAttributeLabel('GateID'),ENT_QUOTES,'UTF-8'); ?>
        <font color="red"><?php echo htmlspecialchars('*',ENT_QUOTES,'UTF-8'); ?></font>
      </h5>
      <?php echo CHtml::dropDownList('p_gate', paramdeep('plateAuthorizations','default','gate'), $gates, array('class'=>'span2  chzn-select', 'data-placeholder' => Yii::t('app', 'Gate...')));; ?>
      <h5>
        <?php echo htmlspecialchars(PlateAuthorization::model()->getAttributeLabel('TimeID'),ENT_QUOTES,'UTF-8'); ?>
        <font color="red"><?php echo htmlspecialchars('*',ENT_QUOTES,'UTF-8'); ?></font>
      </h5>
      <?php echo CHtml::dropDownList('p_time', paramdeep('plateAuthorizations','default','time'), $times, array('class'=>'span2  chzn-select', 'data-placeholder' => Yii::t('app', 'Time zone...')));; ?>
      <h5><?php echo htmlspecialchars(PlateAuthorization::model()->getAttributeLabel('action'),ENT_QUOTES,'UTF-8'); ?></h5>
      <?php echo CHtml::textArea('p_action', paramdeep('plateAuthorizations','default','plateAuthAction'), array('class'=>'span2', 'maxlength' => '250'));; ?>
      <h5><?php echo htmlspecialchars(PlateAuthorization::model()->getAttributeLabel('Note'),ENT_QUOTES,'UTF-8'); ?></h5>
      <?php echo CHtml::textArea('p_note', paramdeep('plateAuthorizations','default','plateAuthNote'), array('class'=>'span2', 'maxlength' => '250'));; ?>
      <br />
      <br />
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'submit'), array('name', 'create'), array('value', (t('Create')))), 'html5', 'UTF-8'); ?> />
      <?php $this->endWidget(); ?>
    </div>
  </div>
<?php } ?>
<br />
<a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $goback_url)), 'html5', 'UTF-8'); ?>>
  <h4><?php echo htmlspecialchars(t('Go back'),ENT_QUOTES,'UTF-8'); ?></h4>
</a>
