<?php $alertPresenter = new AlertPresenter($alert); ?>
<h3>
  <span>
    <?php echo $alertPresenter->getLevelIcon(); ?>
  </span>
  <span>
    <?php echo htmlspecialchars(t('Alert'),ENT_QUOTES,'UTF-8'); ?>
    <?php echo htmlspecialchars('#',ENT_QUOTES,'UTF-8'); ?>
    <?php echo htmlspecialchars($alertPresenter->id,ENT_QUOTES,'UTF-8'); ?>
    <?php if(user()->checkAccess('alert_delete')) { ?>
      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-trash'), array('href', (url('alert/delete',array('id'=>$alert->id)))), array('onclick', ('return confirm(\'' . (t('Confirm?')) . '\');'))), 'html5', 'UTF-8'); ?>></a>
    <?php } ?>
  </span>
  <span>
    <?php $this->renderPartial('/shared/_bookmarkIcon', array('hasBookmark'=>$alert->bookmark, 'id_reference' => $alert->id, 'type' => Bookmark::TYPE_ALERT)); ?>
  </span>
</h3>
<table class="table table-striped table-condensed">
  <tbody>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Description'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars(t($alert->description),ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Note'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php $this->renderPartial('/shared/_alertNote', array('alert' => $alertPresenter)); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Action'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($alertPresenter->action,ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Status'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php if($alert->isNew()) { ?>
          <?php echo htmlspecialchars(t('To be managed'),ENT_QUOTES,'UTF-8'); ?>
        <?php } else if($alert->isTakenInCharge()) { ?>
          <?php echo htmlspecialchars(t('Taken in charge'),ENT_QUOTES,'UTF-8'); ?>
        <?php } else if($alert->isManaged()) { ?>
          <?php echo htmlspecialchars(t('Managed'),ENT_QUOTES,'UTF-8'); ?>
        <?php } ?>
      </td>
    </tr>
    <?php if($alert->isTakenInCharge() || $alert->isManaged()) { ?>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Taken in charge by'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php echo htmlspecialchars($alert->takenInChargeOperator->username,ENT_QUOTES,'UTF-8'); ?>
          <p>
            <?php echo htmlspecialchars(t('at'),ENT_QUOTES,'UTF-8'); ?>
            <?php echo htmlspecialchars(DateHelper::formatLocalDate($alert->taken_in_charge_time),ENT_QUOTES,'UTF-8'); ?>
            <?php echo htmlspecialchars(DateHelper::formatISO9075Time($alert->taken_in_charge_time),ENT_QUOTES,'UTF-8'); ?>
          </p>
        </td>
      </tr>
    <?php } ?>
    <?php if($alert->isManaged()) { ?>
      <tr>
        <td>
          <?php echo htmlspecialchars(t('Managed by'),ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php echo htmlspecialchars($alert->managedByOperator->username,ENT_QUOTES,'UTF-8'); ?>
          <p>
            <?php echo htmlspecialchars(t('at'),ENT_QUOTES,'UTF-8'); ?>
            <?php echo htmlspecialchars(DateHelper::formatLocalDate($alert->managed_time),ENT_QUOTES,'UTF-8'); ?>
            <?php echo htmlspecialchars(DateHelper::formatISO9075Time($alert->managed_time),ENT_QUOTES,'UTF-8'); ?>
          </p>
        </td>
      </tr>
    <?php } ?>
    <tr>
      <td>
        <?php echo htmlspecialchars(t('Comment'),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <div class="comment-field">
          <?php if(isset($form)) { ?>
            <?php echo $form->textFieldRow($alert, 'comment', array( 'labelOptions' => array('label' => false))); ?>
          <?php } else { ?>
            <?php echo htmlspecialchars(t($alert->comment),ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </div>
      </td>
    </tr>
  </tbody>
</table>
