<div id="session-reports-viewer-page">
  <div class="page-header">
    <h2><?php echo htmlspecialchars(t('Preview'),ENT_QUOTES,'UTF-8'); ?></h2>
  </div>
  <div class="session-reports-viewer-container">
    <table class="table table-striped table-condensed">
      <thead>
        <tr>
          <td><?php echo htmlspecialchars(t('Gate Group'),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars(t('Report'),ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
      </thead>
      <tbody>
        <?php foreach($pdfs as $gateGroup => $pdf) { ?>
          <tr>
            <td><?php echo htmlspecialchars($gateGroup,ENT_QUOTES,'UTF-8'); ?></td>
            <td>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small' . ' ' . 'show-session-report-btn')), array('data-pdf-report', (base64_encode($pdf)))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(t("View"),ENT_QUOTES,'UTF-8'); ?>
              </a>
            </td>
          </tr>
        <?php } ?>
      </tbody>
    </table>
  </div>
  <?php $generateBtnDisabled = ""; ?>
  <?php if ( ($workPeriod->generatedReportsCount > 0) ) { ?>
    <?php $generateBtnDisabled = "disabled"; ?>
  <?php } ?>
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small')), array('class', $generateBtnDisabled), array('href', (Yii::app()->createAbsoluteUrl('report/createByService', array('serviceID' => $service->ID))))), 'html5', 'UTF-8'); ?>>
    <?php echo htmlspecialchars(t("Generate"),ENT_QUOTES,'UTF-8'); ?>
  </a>
  <div id="session-report-viewer-modal" class="modal hide fade">
    <div class="modal-header">
      <button class="close" aria-hidden="true" data-dismiss="modal" type="button">x</button>
      <h3><?php echo htmlspecialchars(t('Preview'),ENT_QUOTES,'UTF-8'); ?></h3>
    </div>
    <div class="modal-body">
      <div class="iframe-container">
        <iframe class="report-iframe" src="" style="width:100%;height:600px;display:block;margin-left:auto;margin-right:auto"></iframe>
      </div>
    </div>
    <div class="modal-footer"></div>
  </div>
</div>
