<?php $countryList = CountryList::localized(); ?>
<h1><?php echo htmlspecialchars(t('Plate Authorizations'),ENT_QUOTES,'UTF-8'); ?></h1>
<table class="table table-condensed">
  <thead>
    <th style="width: 30px;"></th>
    <th><?php echo htmlspecialchars(t('List'),ENT_QUOTES,'UTF-8'); ?></th>
    <th><?php echo htmlspecialchars(t('Plate'),ENT_QUOTES,'UTF-8'); ?></th>
    <th><?php echo htmlspecialchars(t('Nationality'),ENT_QUOTES,'UTF-8'); ?></th>
  </thead>
  <tbody>
    <?php foreach($plateAuths as $p) { ?>
      <tr>
        <td>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('PlateAuthorization/view', array('id'=>$p->ID))))), 'html5', 'UTF-8'); ?>>
            <div class="icon-eye-open"></div>
          </a>
        </td>
        <td><?php echo htmlspecialchars($p->plate_list->getListTitle(),ENT_QUOTES,'UTF-8'); ?></td>
        <td><?php echo htmlspecialchars($p->vehicle->Targa,ENT_QUOTES,'UTF-8'); ?></td>
        <td>
          <?php $nat = $p->vehicle->Nationality; ?>
          <?php if($this->printCountryFlag($nat)); ?>
          <?php echo htmlspecialchars($countryList[$nat],ENT_QUOTES,'UTF-8'); ?>
        </td>
      </tr>
    <?php } ?>
  </tbody>
</table>
