<?php if(count($items) > 0) { ?>
  <div class="admin-menu-container span3 pull-right">
    <div class="admin-menu-title">
      <?php echo htmlspecialchars(t($title),ENT_QUOTES,'UTF-8'); ?>
    </div>
    <?php $menuItemsDisplayed = 0; ?>
    <?php foreach($items as $itemId => $item) { ?>
      <?php $auth=$item['auth']; ?>
      <?php $visible=$item['visible']; ?>
      <?php $visible = empty($visible) ? true : eval('return ('.intval($visible).');'); ?>
      <?php if($visible && (isEmpty($auth) || user()->checkAccess($auth))) { ?>
        <?php $menuItemsDisplayed++; ?>
        <section>
          <span class="title">
            <?php $rawUrl = $item['url_raw']; ?>
            <?php if(empty($rawUrl)) { ?>
              <?php $urlInfo = $item['url']; ?>
              <?php if(is_string($urlInfo)) { ?>
                <?php $action = $urlInfo; ?>
                <?php $params = array(); ?>
                <?php $confirm = $item['confirm']; ?>
              <?php } else { ?>
                <?php $action = array_first($urlInfo); ?>
                <?php $urlInfo = array_remove_at($urlInfo, 0);; ?>
                <?php $params = $urlInfo; ?>
                <?php $confirm = $item['confirm']; ?>
              <?php } ?>
              <?php $url = $this->createUrl($action, $params); ?>
            <?php } else { ?>
              <?php $url = $rawUrl; ?>
            <?php } ?>
            <?php if(empty($confirm)) { ?>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $url)), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t($item['label']),ENT_QUOTES,'UTF-8'); ?></a>
            <?php } else { ?>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $url), array('onclick', ('return confirm(\'' . $confirm . '\')'))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t($item['label']),ENT_QUOTES,'UTF-8'); ?></a>
            <?php } ?>
          </span>
        </section>
      <?php } ?>
    <?php } ?>
    <?php if ( $menuItemsDisplayed <= 0 ) { ?>
      <section>
        <span class="title">
          <?php echo htmlspecialchars(Yii::t("app", "No  availabe action")        ,ENT_QUOTES,'UTF-8'); ?>
        </span>
      </section>
    <?php } ?>
  </div>
<?php } ?>
