<?php

use FactoryGirl\Factory as FactoryGirl;

class EventTest extends DbTestCase
{
  public function testValidationResultIssApproved()
  {
    $event = FactoryGirl::create('Event', array());
    foreach(array('approved', 'invalid') as $alias)
     $this->createEventBehavior($event, $alias);
    
    $event->updateStatus();
    $this->assertEquals(Event::VALIDATION_RESULT_APPROVED, $event->validation_result);
  }

  public function testValidatioResultIsPending()
  {
    $event = FactoryGirl::create('Event', array());
    foreach(array('approved', 'invalid', 'pending') as $alias)
      $this->createEventBehavior($event, $alias);

    $event->updateStatus();
    $this->assertEquals(Event::VALIDATION_RESULT_PENDING, $event->validation_result);
  }

  public function testValidationResultIsInvalid()
  {
    $event = FactoryGirl::create('Event', array());
    foreach(array('invalid', 'invalid') as $alias)
      $this->createEventBehavior($event, $alias);

    $event->updateStatus();
    $this->assertEquals(Event::VALIDATION_RESULT_INVALID, $event->validation_result);
  }

  public function testValidationResultIsUnsetBecauseNew()
  {
    $event = FactoryGirl::create('Event', array());
    foreach(array('pending', 'approved', 'invalid') as $alias)
      $this->createEventBehavior($event, $alias);
    $this->insertNewEventBehavior($event);

    $event->updateStatus();
    $this->assertEquals('', $event->validation_result);
  }

  private function createEventBehavior($event, $alias = null)
  {
    return FactoryGirl::create('EventBehavior', array('id_event' => $event->ID), $alias);
  }

  private function insertNewEventBehavior($event)
  {
    $eventBehavior = FactoryGirl::build('EventBehavior', array('id_event' => $event->ID));
    $eventBehavior->validation_result = '';
    $eventBehavior->save(false);
    return $eventBehavior;
  }

}
