<?php
/** @var CustomPropertyTypeController $this */
/** @var CustomPropertyType $model */

$this->menu=array(
	array('label'=>t('Create CustomPropertyType'),'url'=>array('create'),'visible'=>user()->checkAccess('custom_property_type_create')),
);

?>
<h1>Manage Custom Property Types</h1>

<?php $this->widget('bootstrap.widgets.TbGridView',array(
	'id'=>'custom-property-type-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		'type',
		'label',
		'description',
		'is_default',
    array(
          'class'=>'bootstrap.widgets.TbButtonColumn',
          'buttons'=>array
          (
            'view' => array
            (
                'label'=>t('View'),                
                'visible'=>'user()->checkAccess("custom_property_type_view")',
            ),
            'update' => array
            (
                'label'=>t('Update'),                
                'visible'=>'user()->checkAccess("custom_property_type_update")',
            ),
            'delete' => array
            (
                'label'=>t('Delete'),                
                'visible'=>'user()->checkAccess("custom_property_type_delete")',
                'click'=>"return confirm('".t('Do you confirm?')."');",
            ),
          ),
        ),
	),
)); ?>
