<?php
/** @var ViolationCodeController $this */
/** @var ViolationCode $model */

$this->menu=array(
	array('label'=>t('Create ViolationCode'),'url'=>array('create'),'visible'=>user()->checkAccess('violation_code_create')),
);

?>
<h1>Manage Violation Codes</h1>

<?php $this->widget('bootstrap.widgets.TbGridView',array(
	'id'=>'violation-code-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		'name',
		'id_behavior',
		'description',
		'has_goods',
    array(
          'class'=>'bootstrap.widgets.TbButtonColumn',
          'buttons'=>array
          (
            'view' => array
            (
                'label'=>t('View'),                
                'visible'=>'user()->checkAccess("violation_code_view")',
            ),
            'update' => array
            (
                'label'=>t('Update'),                
                'visible'=>'user()->checkAccess("violation_code_update")',
            ),
            'delete' => array
            (
                'label'=>t('Delete'),                
                'visible'=>'user()->checkAccess("violation_code_delete")',
                'click'=>"return confirm('".t('Do you confirm?')."');",
            ),
          ),
        ),
	),
)); ?>
