<?php
$this->breadcrumbs = array (
    'Ztls' => array (
        'index' 
    ),
    $model->ID 
);

$this->menu = array (
    array (
        'label' => 'List Ztl',
        'url' => array (
            'index' 
        ) 
    ),
    array (
        'label' => 'Create Ztl',
        'url' => array (
            'create' 
        ) 
    ),
    array (
        'label' => 'Update Ztl',
        'url' => array (
            'update',
            'id' => $model->ID 
        ) 
    ),
    array (
        'label' => 'Delete Ztl',
        'url' => array (
            'delete',
            'id' => $model->ID 
        ),
        'confirm' => 'Are you sure you want to delete this item?' 
    ),
    array (
        'label' => 'Manage Ztl',
        'url' => array (
            'admin' 
        ) 
    ) 
);
?>

<h1><?php echo(t("View Ztl")." $model->ID"); ?></h1>

<?php

$this->widget ( 'bootstrap.widgets.TbDetailView', array (
    'data' => $model,
    'attributes' => array (
        'ID',
        'Descrizione',
        array (
            'name' => 'GateID',
            'type' => 'raw',
            value => SystemInfoHelper::getGateCoolName ( $model->GateID ) 
        ),
        array (
            'name' => 'TimeID',
            'type' => 'raw',
            value => $model->getIconTag () . SystemInfoHelper::getTimeScheduleCoolName ( $model->TimeID ) 
        ),
        array (
            'name' => 'Transito',
            'type' => 'raw',
            value => SystemInfoHelper::getTransitoCoolName ( $model->Transito ) 
        ),
        'epoch' 
    ) 
) );

$timeSchedule = $model->time;
if ($timeSchedule != null)
{
  /** @var TimeSchedule $timeSchedule */
  echo ("<h3>" . t ( 'Time Schedule' ) . "</h3>");
  
  $hasTimeRange = ($timeSchedule->start_month != null && $timeSchedule->end_month != null && $timeSchedule->start_day != null && $timeSchedule->end_day != null);
  $timeRangeValue = "";
  if ($hasTimeRange)
  {
    $months = DateHelper::monthList ( true );
    $timeRangeValue = $timeSchedule->start_day . " " . $months [$timeSchedule->start_month] ['label'] . ' - ' . $timeSchedule->end_day . " " . $months [$timeSchedule->end_month] ['label'];
  }
  
  $this->widget ( 'bootstrap.widgets.TbDetailView', array (
      'data' => $timeSchedule,
      'attributes' => array (
          array (
              'name' => 'ID',
              'type' => 'html',
              'value' => '<a href="' . url ( 'timeSchedule/view', array (
                  'id' => $timeSchedule->ID 
              ) ) . '">' . $timeSchedule->ID . '</a>' 
          ),
          'Descrizione',
          array (
              'label' => t ( 'Range' ),
              'type' => 'html',
              'value' => $timeRangeValue,
              'visible' => $hasTimeRange 
          ) 
      ) 
  ) );
  
  $this->renderPartial ( '/timeSchedule/_timeSlotsDetails', array (
      'timeSchedule' => $timeSchedule 
  ) );
}
?>
