#= require ./behavior

class window.NavigateToCoords extends window.Behavior
  init: ->
    @map = @domData('navigate-to-target')[0].contentWindow

    @$dom.click =>
      @navigateTo(@getLatitude(), @getLongitude())

  navigateTo: (latitude, longitude) ->
    @map.ZoomPunto latitude, longitude, @getZoomLevel(), "UTM-ED50"

  getLatitude: ->
    @data('navigate-to-latitude')

  getLongitude: ->
    @data('navigate-to-longitude')

  getZoomLevel: ->
    @data('navigate-to-zoom', 6)
