$ ->
  
  statchart = null
  opts =
    lines: 13
    length: 7
    width: 4
    radius: 10
    corners: 1 
    rotate: 0
    color: '#000'
    speed: 1
    trail: 60
    shadow: false
    hwaccel: false
    className: 'spinner'
    zIndex: 2e9
    top: 5
    left: 'auto'
  
  if ($('#debug-export-image-page').length > 0)

    $(".icon-calendar").click ->
      $(@).siblings('.date-picker').datepicker('show')

    

    class ExportImageForm

      constructor: (@$form) ->
        @attachStartPicker()
        @attachEndPicker()
        @attachCheckboxes()
        @attachSpeedSlider()

        
        $("button[type='submit']", @$form).click =>
          @listEvents()
          false
        $("button[type='export']", @$form).click =>
          @exportEventsImages()
          false
 
      getUnixStart: ($dom) ->
        moment($dom.datepicker('getDate')).startOf('day').unix()

      getUnixEnd: ($dom) ->
      	moment($dom.datepicker('getDate')).endOf('day').unix()

      attachStartPicker: ->
        $picker = $("#datepicker-start-date", @$form)
        $picker.change =>
          $("#start-timestamp", @$form).val(@getUnixStart($picker))

      attachEndPicker: ->
        $picker = $("#datepicker-end-date", @$form)
        $picker.change =>
          $("#end-timestamp", @$form).val(@getUnixEnd($picker))

      attachCheckboxes: ->
        $("#gates button, #vehicles button, #nationalities button", @$form).click ->
          $input = $('input', @)
          if $input.is(':checked')
            $input.attr('checked', false)
          else
            $input.attr('checked', true)

      attachSpeedSlider: ->
        $("#slider-range", @$form).slider
          range: true
          min: 10
          max: 300
          step: 5
          slide: (event, ui) ->
            $("#min-speed", @$form).val ui.values[0]
            $("#max-speed", @$form).val ui.values[1]

      clearExportResult: ->
        canvas = $("#export-result").html("")
   
        
      exportImages: ->
        spinner = new Spinner(opts).spin($("#spinner").get(0))
        @clearExportResult()
                     
        $.ajax
          type : "POST"
          url : "#{settings.baseUrl}/debug/listEventToExport"
          data : @$form.serialize()
          timeout: 60000
          
          success: (html) ->
            spinner.stop()
            $("#export-result").html(html)
            $("#export-event-table-result").nuclearifyAll()

          error: (message) ->
            spinner.stop()
            $("#export-result").html(message)  

      listEvents: ->
        spinner = new Spinner(opts).spin($("#spinner").get(0))
        @clearExportResult()
                     
        $.ajax
          type : "POST"
          url : "#{settings.baseUrl}/debug/listEventToExport"
          data : @$form.serialize()
          timeout: 60000
          
          success: (html) ->
            spinner.stop()
            $("#export-result").html(html)

          error: (message) ->
            spinner.stop()
            $("#export-result").html(message) 


      exportEventsImages: ->
        spinner = new Spinner(opts).spin($("#spinner").get(0))
        @clearExportResult()
                     
        $.ajax
          type : "POST"
          url : "#{settings.baseUrl}/debug/exportEventsImages"
          data : @$form.serialize()
          timeout: 60000
          
          success: (html) ->
            spinner.stop()
            $("#export-result").html(html)

          error: (message) ->
            spinner.stop()
            $("#export-result").html(message) 

    
        
    new ExportImageForm($("#export-image-form"))
