<?php

class CurrentWorkPeriod extends CApplicationComponent
{

  private $_model = null;

  public function getModel()
  {
    if (!isset($this->_model))
    {
      $user = Yii::app()->user->model;
      $model = WorkPeriod::model()->byUser($user)->open()->find();
      if ($model === null)
        throw new CHttpException(500, Yii::t('app', 'Cannot find current work period for user.'));
      $this->_model = $model;
    }

    return $this->_model;
  }

  public function getId()
  {
    $model = $this->model;
    return $model->id;
  }
}
