<?php

/**
 * class FormModel extends CFormModel
 * @author p6
 *
 */
class FormModel extends CFormModel
{
  public function getRecordClassName()
  {
    return get_class($this);
  }
  
  public function getLabelsOverride()
  {
    $labels = paramdeep('modelLabelsOverride', $this->getRecordClassName());
    return $labels;
  }
  
  public function getAttributeLabel($name)
  {
    $labels = $this->attributeLabels();
    return $labels[$name];
  }
  
  /**
   * @return array customized attribute labels (name=>label)
   */
  public function attributeLabels()
  {
    $names = $this->attributeNames();

    $labels = array();
    foreach($names as $name)
    {
      $labels[$name] = t($name);
    }

    if(method_exists($this, "myAttributeLabels"))
    {
      $myLabels = $this->myAttributeLabels();
      foreach($myLabels as $myName => $myValue)
      {
        $labels[$myName] = $myValue;
      }
    }

    $customLabels = $this->getLabelsOverride();
    if($customLabels != null)
    {
      foreach($customLabels as $clk => $clv)
      {
        $labels[$clk] = $clv;
      }
    }

    return $labels;
  }

  public function getErrorsHtml()
  {
    $html = "";
    foreach($this->errors as $e)
    {
      if(!empty($html))
        $html .= '<br>'.PHP_EOL;
      if(is_array($e))
        $html .= implode('<br>'.PHP_EOL,$e);
      else
        $html .= $e;
    }
    return $html;
  }

  public function __get($name)
  {
    $getter = 'get'.$name;
    if(method_exists($this,$getter))
      return $this->$getter();

    return parent::__get($name);
  }

  public function __set($name, $value)
  {
    $setter = 'set'.$name;
    if (method_exists($this, $setter))
      return $this->$setter($value);

    return parent::__set($name, $value);
  }

}
