<?php

class m131118_103503_add_device_model_to_gate extends MyDbMigration
{
	public function up()
	{
		if ($this->dbConnection->schema->getTable('GateTable')->getColumn('device_model') == null)
			$this->addColumn('GateTable', 'device_model', 'string  DEFAULT NULL');
		
		$this->execute(
				"CREATE TABLE IF NOT EXISTS `device_type` (
			        `id` int(11) NOT NULL AUTO_INCREMENT,
			        `name` varchar(30) NOT NULL,
			        `type` varchar(30) NOT NULL,
			        PRIMARY KEY (`id`)
			  ) ENGINE=MyISAM  DEFAULT CHARSET=utf8"
		);

		$this->execute(
				'INSERT INTO device_type (name, type) VALUES
				("T-EXSPEED", "TRS"),
				("T-RED HD",  "TRS"),
				("T-XROAD",   "TRS"),
				("T-RED",   	"TRED"),
				("T-ID",   		"TID"),
				("T-ID HD",   "TID")'
		);
		
	}

	public function down()
	{
		if ($this->dbConnection->schema->getTable('GateTable')->getColumn('device_model') == null)
			$this->dropColumn('GateTable', 'device_model');

		$this->dropTable('device_type');
		
		return true;
	}

	/*
	// Use safeUp/safeDown to do migration with transaction
	public function safeUp()
	{
	}

	public function safeDown()
	{
	}
	*/
}