<?php

/**
 * This is the model class for table "section".
 *
 * The followings are the available columns in table 'section':
 * @property string $id
 * @property string $name
 * @property string $description
 * @property string $id_gate_start
 * @property string $id_gate_end
 * @property double $road_length
 * @property integer $enabled
 * @property double $road_speed_limit
 * @property string $road_speed_limit_unit
 * @property double $road_speed_threshold
 * @property string $filter_gate_start
 * @property string $filter_gate_end
 * @property double $discard_delta
 * @property double $final_discard_delta
 * @property string $last_event_time
 * @property string $last_event_id
 * @property string $epoch
 * @property double $min_speed
 * @property double $max_speed
 * @property double $default_speed

 * 
 * @property double Tolerance
 * @property SectionLimits[] limits
 */
class Section extends ActiveRecord
{

  /**
   * Returns the static model of the specified AR class.
   *
   * @param string $className
   *          active record class name.
   * @return Section the static model class
   */
  public static function model($className = __CLASS__)
  {
    return parent::model ( $className );
  }

  /**
   *
   * @return string the associated database table name
   */
  public function tableName()
  {
    return 'section';
  }

  /**
   *
   * @return array validation rules for model attributes.
   */
  public function rules()
  {
    // NOTE: you should only define rules for those attributes that
    // will receive user inputs.
    return array (
        array (
            'id_gate_start, id_gate_end, road_length, enabled, road_speed_limit, road_speed_threshold, filter_gate_start, filter_gate_end, discard_delta, final_discard_delta',
            'required' 
        ),
        array (
            'enabled',
            'numerical',
            'integerOnly' => true 
        ),
        array (
            'road_length, road_speed_limit, road_speed_threshold, discard_delta, final_discard_delta, min_speed, max_speed, default_speed',
            'numerical' 
        ),
        array (
            'name',
            'length',
            'max' => 45 
        ),
        array (
            'description',
            'length',
            'max' => 255 
        ),
        array (
            'id_gate_start, id_gate_end, last_event_id',
            'length',
            'max' => 20 
        ),
        array (
            'road_speed_limit_unit',
            'length',
            'max' => 30 
        ),
        array (
            'filter_gate_start, filter_gate_end',
            'length',
            'max' => 10 
        ),
        array (
            'last_event_time, epoch',
            'safe' 
        ),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array (
            'id, name, description, id_gate_start, id_gate_end, road_length, enabled, road_speed_limit, road_speed_limit_unit, road_speed_threshold, filter_gate_start, filter_gate_end, discard_delta, final_discard_delta, last_event_time, last_event_id, epoch, min_speed, max_speed, default_speed',
            'safe',
            'on' => 'search' 
        ) 
    );
  }

  /**
   *
   * @return array relational rules.
   */
  public function relations()
  {
    // NOTE: you may need to adjust the relation name and the related
    // class name for the relations automatically generated below.
    return array (
        'limits' => array (
            self::HAS_MANY,
            'SectionLimits',
            'section' 
        ),
        'limitsCount' => array (
            self::STAT,
            'SectionLimits',
            'section' 
        ) 
    );
  }

  /**
   *
   * @param long $g1
   *          gate id (gatetable.Gate)
   * @param long $g2
   *          gate id (gatetable.Gate)
   * @return Section[]
   */
  public static function findByGates($g1, $g2)
  {
    return Section::model ()->findAll ( 'id_gate_start=:g1 AND id_gate_end=:g2', array (
        ':g1' => $g1,
        ':g2' => $g2 
    ) );
  }

  /**
   *
   * @return array customized attribute labels (name=>label)
   */
  public function myAttributeLabels()
  {
    return array (
        'id' => 'ID',
        'name' => t ( 'Name' ),
        'description' => t ( 'Description' ),
        'id_gate_start' => t ( 'Gate Start' ),
        'id_gate_end' => t ( 'Gate End' ),
        'road_length' => t ( 'Road Length' ),
        'enabled' => t ( 'Enabled' ),
        'road_speed_limit' => t ( 'Road Speed Limit' ),
        'road_speed_limit_unit' => t ( 'Road Speed Limit Unit' ),
        'road_speed_threshold' => t ( 'Road Speed Threshold' ),
        'filter_gate_start' => t ( 'Filter Gate Start' ),
        'filter_gate_end' => t ( 'Filter Gate End' ),
        'discard_delta' => t ( 'Discard Delta' ),
        'final_discard_delta' => t ( 'Final Discard Delta' ),
        'last_event_time' => t ( 'Last Event Time' ),
        'last_event_id' => t ( 'Last Event' ),
        'epoch' => t ( 'Epoch' ),
        'Tolerance' => t ( 'Tolerance' ) 
    );
  }

  /**
   * Retrieves a list of models based on the current search/filter conditions.
   *
   * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
   */
  public function search()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.
    $criteria = new CDbCriteria ();
    
    $criteria->compare ( 'id', $this->id, true );
    $criteria->compare ( 'name', $this->name, true );
    $criteria->compare ( 'description', $this->description, true );
    $criteria->compare ( 'id_gate_start', $this->id_gate_start, true );
    $criteria->compare ( 'id_gate_end', $this->id_gate_end, true );
    $criteria->compare ( 'road_length', $this->road_length );
    $criteria->compare ( 'enabled', $this->enabled );
    $criteria->compare ( 'road_speed_limit', $this->road_speed_limit );
    $criteria->compare ( 'road_speed_limit_unit', $this->road_speed_limit_unit, true );
    $criteria->compare ( 'road_speed_threshold', $this->road_speed_threshold );
    $criteria->compare ( 'filter_gate_start', $this->filter_gate_start, true );
    $criteria->compare ( 'filter_gate_end', $this->filter_gate_end, true );
    $criteria->compare ( 'discard_delta', $this->discard_delta );
    $criteria->compare ( 'final_discard_delta', $this->final_discard_delta );
    $criteria->compare ( 'last_event_time', $this->last_event_time, true );
    $criteria->compare ( 'last_event_id', $this->last_event_id, true );
    $criteria->compare ( 'epoch', $this->epoch, true );
    
    return new CActiveDataProvider ( $this, array (
        'criteria' => $criteria 
    ) );
  }

  public function getTolerance()
  {
    $tol = $this->road_speed_threshold == 0 ? 0 : $this->road_speed_limit / $this->road_speed_threshold;
    $tol = $tol * 100.0;
    $tol = 100.0 - $tol;
    return round ( $tol, 2 );
  }
}