<?php $form=$this->beginWidget('bootstrap.widgets.TbActiveForm', array( 'id'=>'user-form', 'enableAjaxValidation'=>false )); ?>
<?php $password_timeout_options = array(0=>Yii::t('app', 'Never'),7=>Yii::t('app', 'Every week'),14=>Yii::t('app', 'Every two weeks'),30=>Yii::t('app', 'Every month'),60=>Yii::t('app', 'Every two months'),90=>Yii::t('app', 'Every three months'),180=>Yii::t('app', 'Every six months'),365=>Yii::t('app', 'Every year')); ?>
<p class="help-block">
  <?php echo htmlspecialchars(Yii::t('app', 'Fields with * are required.'),ENT_QUOTES,'UTF-8'); ?>
</p>
<?php echo $form->errorSummary($model); ?>
<?php if($model->isNewRecord) { ?>
  <?php echo $form->textFieldRow($model, 'username', array('class'=>'span5','maxlength'=>256)); ?>
<?php } else { ?>
  <?php echo $form->textFieldRow($model, 'username', array('class'=>'span5','maxlength'=>256,'readonly'=>'readonly')); ?>
<?php } ?>
<?php if($model->isNewRecord || Yii::app()->user->model->canChangePassword($model->id)) { ?>
  <?php echo $form->passwordFieldRow($model, 'password', array('class'=>'span5','maxlength'=>256)); ?>
  <?php echo $form->passwordFieldRow($model, 'password_repeat', array('class'=>'span5','maxlength'=>256)); ?>
<?php } ?>
<?php if(user()->checkAccess('manage_users')) { ?>
  <?php echo $form->radioButtonListInlineRow($model, 'can_change_password', array(0=>Yii::t('app', 'No'), 1=>Yii::t('app', 'Yes'))); ?>
  <?php echo $form->dropDownListRow($model, 'password_timeout', $password_timeout_options); ?>
  <?php echo $form->radioButtonListInlineRow($model, 'refresh_password_at_first_login', array(0=>Yii::t('app', 'No'), 1=>Yii::t('app', 'Yes'))); ?>
<?php } ?>
<?php echo $form->textFieldRow($model, 'email', array('class'=>'span5','maxlength'=>256)); ?>
<?php if($model->isNewRecord || Yii::app()->user->model->id != $model->id) { ?>
  <?php echo $form->radioButtonListInlineRow($model, 'status', array('inactive'=>Yii::t('app', 'Inactive'), 'active'=>Yii::t('app', 'Active'))); ?>
<?php } ?>
<?php echo $form->textFieldRow($model, 'first_name', array('class'=>'span5','maxlength'=>255)); ?>
<?php echo $form->textFieldRow($model, 'last_name', array('class'=>'span5','maxlength'=>255)); ?>
<?php echo $form->textFieldRow($model, 'matriculation_number', array('class'=>'span5','maxlength'=>255)); ?>
<?php if(user()->checkAccess('manage_superuser')) { ?>
  <?php echo $form->checkBoxRow($model, 'superuser'); ?>
<?php } ?>
<?php if(user()->checkAccess('manage_api')) { ?>
  <?php echo $form->textFieldRow($model, 'apikey', array('id'=>'apikeyid', 'class'=>'span5','maxlength'=>255)); ?>
<?php } ?>
<?php if(isset($assignable_roles) && count($assignable_roles) > 0) { ?>
  <?php echo $form->dropDownListRow($model, 'role', $assignable_roles); ?>
<?php } ?>
<div class="form-actions">
  <?php $this->widget('bootstrap.widgets.TbButton', array('buttonType'=>'submit','label'=>$model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Save'),)); ?>
</div>
<?php $this->endWidget(); ?>
