<div id="gate-group-index-page">
  <div class="page-header">
    <h2>
      <li class="icon-cog"></li>
      <?php echo htmlspecialchars(Yii::t("app", "Gate Groups"),ENT_QUOTES,'UTF-8'); ?>
    </h2>
  </div>
  <div class="row">
    <?php $gateGroups = $dataProvider->data; ?>
    <div class="tableContainer pagination-data-container">
      <table class="table table-condensed span12">
        <thead>
          <tr></tr>
          <tr>
            <th><?php echo htmlspecialchars(t('ID'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Name'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Latitude'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Longitude'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Altitude'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Creation date'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('In use'),ENT_QUOTES,'UTF-8'); ?></th>
            <th>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini')), array('href', (Yii::app()->createAbsoluteUrl('gateGroup/create')))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(Yii::t('app', 'New group')   ,ENT_QUOTES,'UTF-8'); ?>
              </a>
            </th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($gateGroups as $gateGroup) { ?>
            <?php $cons = $gateGroup->getConsumers(); ?>
            <?php $inUse = count($cons)>0; ?>
            <tr>
              <td>
                <?php echo htmlspecialchars($gateGroup->ID,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo SystemInfoHelper::getGateGroupCoolName($gateGroup->ID); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gateGroup->latitude,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gateGroup->longitude,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gateGroup->altitude,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gateGroup->epoch,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php if($inUse) { ?>
                  <?php echo htmlspecialchars(t('Yes'),ENT_QUOTES,'UTF-8'); ?>
                <?php } else { ?>
                  <?php echo htmlspecialchars(t('No'),ENT_QUOTES,'UTF-8'); ?>
                <?php } ?>
              </td>
              <td>
                <div class="btn-group">
                  <a class="btn btn-small dropdown-toggle" data-toggle="dropdown" href="#">
                    <?php echo htmlspecialchars(Yii::t("app", "Actions"),ENT_QUOTES,'UTF-8'); ?>
                    <span class="caret"></span>
                  </a>
                  <ul class="dropdown-menu pull-right">
                    <li>
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('gateGroup/update', array('id' => $gateGroup->ID))))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(Yii::t("app", ("Modify")),ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </li>
                    <?php if(!$inUse) { ?>
                      <li>
                        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('gateGroup/delete', array('id' => $gateGroup->ID))))), 'html5', 'UTF-8'); ?>>
                          <?php echo htmlspecialchars(Yii::t("app", ("Delete"))                ,ENT_QUOTES,'UTF-8'); ?>
                        </a>
                      </li>
                    <?php } ?>
                  </ul>
                </div>
              </td>
            </tr>
          <?php } ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
