<?php $currentUrl = Yii::app()->createAbsoluteUrl($this->route,$context); ?>
<?php $hasData = isset($periods) && count($periods->data)>0; ?>
<?php $customValidityPeriods = PlateAuthorizationController::getCustomValidityPeriods(); ?>
<?php $paramDescription = array_get($_REQUEST,"a_description",paramdeep('plateAuthorizations','default','validityPeriodDescription')); ?>
<?php $paramType = array_get($_REQUEST,"a_type",paramdeep('plateAuthorizations','default','validityPeriodType')); ?>
<?php $paramStartDate = array_get($_REQUEST,"a_startDate",date(getFormat_Date())); ?>
<?php $paramEndDate = array_get($_REQUEST,"a_endDate",date(getFormat_Date())); ?>
<div class="page-header">
  <h2>
    <i class="icon-time"></i>
    <?php echo htmlspecialchars(t('Validity periods'),ENT_QUOTES,'UTF-8'); ?>
  </h2>
</div>
<h5>
  <?php $navigate_url_list = Yii::app()->createAbsoluteUrl('plateAuthorization'); ?>
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $navigate_url_list)), 'html5', 'UTF-8'); ?>>
    <i class="icon-file-text-alt"></i>
    <?php echo htmlspecialchars($objList->name,ENT_QUOTES,'UTF-8'); ?>
  </a>
  <?php $navigate_url_user = Yii::app()->createAbsoluteUrl($this->route,array('plateListId'=>$plateListId,'step'=>'1')); ?>
  <i class="icon-long-arrow-right"></i>
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $navigate_url_user)), 'html5', 'UTF-8'); ?>>
    <i class="icon-user"></i>
    <?php echo htmlspecialchars("$objOwner->Nome $objOwner->Cognome",ENT_QUOTES,'UTF-8'); ?>
  </a>
  <?php $navigate_url_vehicle = Yii::app()->createAbsoluteUrl($this->route,array('plateListId'=>$plateListId,'step'=>'2','ownerId'=>$ownerId)); ?>
  <i class="icon-long-arrow-right"></i>
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $navigate_url_vehicle)), 'html5', 'UTF-8'); ?>>
    <i class="icon-truck"></i>
    <?php echo htmlspecialchars($objVehicle->Targa,ENT_QUOTES,'UTF-8'); ?>
  </a>
  <i class="icon-long-arrow-right"></i>
  <i class="icon-time"></i>
  <?php echo htmlspecialchars(t('Select validity period'),ENT_QUOTES,'UTF-8'); ?>
  <i class="icon-long-arrow-right"></i>
  <font color="gray">
    <i class="icon-ok-circle"></i>
    <?php echo htmlspecialchars(t('Select plate authorization'),ENT_QUOTES,'UTF-8'); ?>
  </font>
</h5>
<?php $goback_url = Yii::app()->createAbsoluteUrl($this->route,array('plateListId'=>$plateListId,'step'=>'2','ownerId'=>$ownerId)); ?>
<div class="row">
  <div class="form-box">
    <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',      array('id'=>'validityperiod-search-form','action' => Yii::app()->createUrl($this->route),'method' => 'GET',)); ?>
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'plateListId'), array('value', $plateListId)), 'html5', 'UTF-8'); ?> />
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'ownerId'), array('value', $ownerId)), 'html5', 'UTF-8'); ?> />
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'vehicleId'), array('value', $vehicleId)), 'html5', 'UTF-8'); ?> />
    <input type="hidden" name="step" value="3" />
    <input type="hidden" name="action" value="search" />
    <h3>
      <?php echo htmlspecialchars(t("Search validity periods"),ENT_QUOTES,'UTF-8'); ?>
    </h3>
    <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', 'what'), array('value', $what)), 'html5', 'UTF-8'); ?> />
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $currentUrl)), 'html5', 'UTF-8'); ?>>
      <i class="icon-remove-sign"></i>
    </a>
    <?php $this->endWidget(); ?>
    <?php if ($hasData) { ?>
      <div class="tableContainer pagination-data-container">
        <table class="table table-condensed">
          <thead>
            <tr>
              <th></th>
              <th><?php echo htmlspecialchars(ValidityPeriod::model()->getAttributeLabel('Descrizione'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(ValidityPeriod::model()->getAttributeLabel('Tipo'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(ValidityPeriod::model()->getAttributeLabel('DataInizio'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(ValidityPeriod::model()->getAttributeLabel('DataFine'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(ValidityPeriod::model()->getAttributeLabel('epoch'),ENT_QUOTES,'UTF-8'); ?></th>
              <th><?php echo htmlspecialchars(t('Actions'),ENT_QUOTES,'UTF-8'); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($periods->data as $period) { ?>
              <?php $period_url = Yii::app()->createAbsoluteUrl($this->route,array('plateListId'=>$plateListId,'step'=>'4','ownerId'=>$ownerId,'vehicleId'=>$vehicleId,'validityPeriodId'=>$period->ID)); ?>
              <?php $delete_url = Yii::app()->createUrl('plateAuthorization/whiteListWizardDelete',array('listId'=>$plateListId, 'objType'=>'period', 'objId'=>$period->ID, 'returnUrl'=>$currentUrl)); ?>
              <tr>
                <td>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $period_url)), 'html5', 'UTF-8'); ?>>
                    <i class="icon-eye-open"></i>
                  </a>
                </td>
                <td>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $period_url)), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars($period->Descrizione,ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </td>
                <td>
                  <?php echo htmlspecialchars($period->Tipo,ENT_QUOTES,'UTF-8'); ?>
                </td>
                <td>
                  <?php echo htmlspecialchars(DateHelper::formatISO9075DateTime($period->DataInizio),ENT_QUOTES,'UTF-8'); ?>
                </td>
                <td>
                  <?php echo htmlspecialchars(DateHelper::formatISO9075DateTime($period->DataFine),ENT_QUOTES,'UTF-8'); ?>
                </td>
                <td>
                  <?php echo htmlspecialchars(DateHelper::formatISO9075DateTime($period->epoch),ENT_QUOTES,'UTF-8'); ?>
                </td>
                <td>
                  <?php if(Yii::app()->user->checkAccess("plate_auth_delete")) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $delete_url), array('onclick', ('return confirm(\'' . (t('Are you sure you want to delete this item?')) . '\')'))), 'html5', 'UTF-8'); ?>>
                      <i class="icon-trash"></i>
                    </a>
                  <?php } ?>
                </td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
      <?php if (isset($periods->pagination)) { ?>
        <div class="pagination pagination-links-container">
          <?php $this->widget('bootstrap.widgets.TbPager', array('pages' => $periods->pagination)); ?>
        </div>
      <?php } ?>
    <?php } else { ?>
      <h4><?php echo htmlspecialchars(Yii::t("app", "No results"),ENT_QUOTES,'UTF-8'); ?></h4>
    <?php } ?>
  </div>
</div>
<?php if(true) { ?>
  <br />
  <div class="row">
    <div class="form-box">
      <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',      array('id'=>'validityperiod-create-form','action' => Yii::app()->createUrl($this->route),'method' => 'POST',)); ?>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'plateListId'), array('value', $plateListId)), 'html5', 'UTF-8'); ?> />
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'ownerId'), array('value', $ownerId)), 'html5', 'UTF-8'); ?> />
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'vehicleId'), array('value', $vehicleId)), 'html5', 'UTF-8'); ?> />
      <input type="hidden" name="step" value="3" />
      <input type="hidden" name="action" value="create" />
      <h3><?php echo htmlspecialchars(t("Create validity period"),ENT_QUOTES,'UTF-8'); ?></h3>
      <div class="control-group">
        <div class="btn-group" id="when-buttons">
          <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('today')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(t('Today'),ENT_QUOTES,'UTF-8'); ?>
          </button>
          <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('thisweek')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(t('This week'),ENT_QUOTES,'UTF-8'); ?>
          </button>
          <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('thismonth')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(t('This month'),ENT_QUOTES,'UTF-8'); ?>
          </button>
          <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('thisyear')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(t('This year'),ENT_QUOTES,'UTF-8'); ?>
          </button>
        </div>
      </div>
      <div class="control-group">
        <div class="btn-group" id="when-buttons">
          <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('tomorrow')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(t('Tomorrow'),ENT_QUOTES,'UTF-8'); ?>
          </button>
          <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('nextweek')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(t('Next week'),ENT_QUOTES,'UTF-8'); ?>
          </button>
          <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('nextmonth')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(t('Next month'),ENT_QUOTES,'UTF-8'); ?>
          </button>
          <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', ('nextyear')), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(t('Next year'),ENT_QUOTES,'UTF-8'); ?>
          </button>
        </div>
      </div>
      <?php if(is_array_ex($customValidityPeriods,true)) { ?>
        <div class="control-group">
          <div class="btn-group" id="when-buttons">
            <?php $btnCVPindex=0; ?>
            <?php foreach($customValidityPeriods as $cvpLabel => $cvpDate) { ?>
              <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DateRangeSetter')), array('data-daterange-setter-when', $cvpDate), array('data-daterange-setter-start-date', ('#startDate')), array('data-daterange-setter-start-time', ('#startTime')), array('data-daterange-setter-end-date', ('#endDate')), array('data-daterange-setter-end-time', ('#endTime'))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars($cvpLabel,ENT_QUOTES,'UTF-8'); ?>
              </button>
              <?php $btnCVPindex++; ?>
              <?php if($btnCVPindex % 4 == 0 && $btnCVPindex > 0) { ?>
                <br />
              <?php } ?>
            <?php } ?>
          </div>
        </div>
      <?php } ?>
      <h5><?php echo htmlspecialchars(ValidityPeriod::model()->getAttributeLabel('Descrizione'),ENT_QUOTES,'UTF-8'); ?></h5>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', 'a_description'), array('value', $paramDescription)), 'html5', 'UTF-8'); ?> />
      <?php echo htmlspecialchars(t("(for example: 'July 2012')"),ENT_QUOTES,'UTF-8'); ?>
      <h5><?php echo htmlspecialchars(ValidityPeriod::model()->getAttributeLabel('Tipo'),ENT_QUOTES,'UTF-8'); ?></h5>
      <?php echo CHtml::dropDownList('a_type', $paramType, paramdeep('plateAuthorizations','validityPeriodType'), array('class'=>'span2  chzn-select', 'data-placeholder' => Yii::t('app', 'Type...')));; ?>
      <h5><?php echo htmlspecialchars(ValidityPeriod::model()->getAttributeLabel('DataInizio'),ENT_QUOTES,'UTF-8'); ?></h5>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'startDate'), array('class', ('date-picker' . ' ' . 'span2')), array('type', ('text')), array('name', ('a_startDate')), array('value', $paramStartDate), array('readonly', ('true'))), 'html5', 'UTF-8'); ?> />
      <input id="end-timestamp" type="hidden" />
      <span class="add-on icon-calendar"></span>
      <h5><?php echo htmlspecialchars(t('Start time'),ENT_QUOTES,'UTF-8'); ?></h5>
      <div id="datepicker-start-time" class="input-prepend input-append time-picker">
        <span class="add-on"><?php echo htmlspecialchars(t('From'),ENT_QUOTES,'UTF-8'); ?></span>
        <input <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'startTime'), array('class', 'span1'), array('data-format', (Yii::app()->params['timeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'a_startTime'), array('value', (date('H:i')))), 'html5', 'UTF-8'); ?> />
        <span class="add-on">
          <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
        </span>
      </div>
      <h5><?php echo htmlspecialchars(ValidityPeriod::model()->getAttributeLabel('DataFine'),ENT_QUOTES,'UTF-8'); ?></h5>
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'endDate'), array('class', ('date-picker' . ' ' . 'span2')), array('type', ('text')), array('name', ('a_endDate')), array('value', $paramEndDate), array('readonly', ('true'))), 'html5', 'UTF-8'); ?> />
      <input id="start-timestamp" type="hidden" />
      <span class="add-on icon-calendar"></span>
      <h5><?php echo htmlspecialchars(t('End time'),ENT_QUOTES,'UTF-8'); ?></h5>
      <div id="datepicker-end-time" class="input-prepend input-append time-picker">
        <span class="add-on"><?php echo htmlspecialchars(t('To'),ENT_QUOTES,'UTF-8'); ?></span>
        <input <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'endTime'), array('class', 'span1'), array('data-format', (Yii::app()->params['timeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'a_endTime'), array('value', (date('H:i')))), 'html5', 'UTF-8'); ?> />
        <span class="add-on">
          <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
        </span>
      </div>
      <br />
      <br />
      <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'submit'), array('name', 'create'), array('value', (t('Create')))), 'html5', 'UTF-8'); ?> />
      <?php $this->endWidget(); ?>
    </div>
  </div>
<?php } ?>
<br />
<a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $goback_url)), 'html5', 'UTF-8'); ?>>
  <h4><?php echo htmlspecialchars(t('Go back'),ENT_QUOTES,'UTF-8'); ?></h4>
</a>
