<?php

use FactoryGirl\Factory as FactoryGirl;

class ServiceProviderTest extends DbTestCase
{
  public function testValidateUniqueServicePerStatus()
  {
    $services = array(
      FactoryGirl::create('Service', array(), 'active'),
      FactoryGirl::create('Service', array(), 'active'),
    );

    $serviceProvider = new ServiceProvider($services);
    $this->assertFalse($serviceProvider->valid());
    $this->assertContains("An incomplete status has more than one service for this gate group.", $serviceProvider->errors);
  }

  public function testValidateUniqueStatus()
  {
    $services = array(
      FactoryGirl::create('Service', array(), 'waitingActivation'),
      FactoryGirl::create('Service', array(), 'waitingTermination'),
    );

    $serviceProvider = new ServiceProvider($services);
    $this->assertFalse($serviceProvider->valid());
    $this->assertContains("There are more than one incomplete status for this gate group.", $serviceProvider->errors);
  }

  public function testIsEmpty()
  {
    $serviceProvider = new ServiceProvider(array());
    $this->assertTrue($serviceProvider->isEmpty);

    $serviceProvider = new ServiceProvider(array(FactoryGirl::create('Service', array(), 'active')));
    $this->assertFalse($serviceProvider->isEmpty);
  }

  public function testGetService()
  {
    $service = FactoryGirl::create('Service', array(), 'waitingConfirmation');
    $serviceProvider = new ServiceProvider(array($service));

    $this->assertEquals($service, $serviceProvider->service);
  }

}
