<?php
/** @var BehaviorController $this */
/** @var Behavior $model */

$this->menu=array(
	array('label'=>t('Create Behavior'),'url'=>array('create'),'visible'=>user()->checkAccess('behavior_create')),
	array('label'=>t('Create Default Behaviors'),'url'=>array('createdefaults'),'visible'=>user()->checkAccess('behavior_create')),
);

?>
<h1>Manage Behaviors</h1>

<?php $this->widget('bootstrap.widgets.TbGridView',array(
	'id'=>'behavior-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'ID',
		'name',
		'description',
		'tag',
		'confirmable',
		'epoch',
		/*
		'priority',
		'alarm_tag_name',
		*/
    array(
          'class'=>'bootstrap.widgets.TbButtonColumn',
          'buttons'=>array
          (
            'view' => array
            (
                'label'=>t('View'),                
                'visible'=>'user()->checkAccess("behavior_view")',
            ),
            'update' => array
            (
                'label'=>t('Update'),                
                'visible'=>'user()->checkAccess("behavior_update")',
            ),
            'delete' => array
            (
                'label'=>t('Delete'),                
                'visible'=>'user()->checkAccess("behavior_delete")',
                'click'=>"return confirm('".t('Do you confirm?')."');",
            ),
          ),
        ),
	),
)); ?>
