<h1>New logger</h1>
<?php
echo CHtml::link ( 'Back To Loggers', url ( 'debug/loggers' ) );

$route = new $type ();
/** @var CLogRoute $route */
if (! isset ( $_REQUEST ['loggerId'] ))
{
  if ($route->levels == '')
    $route->levels = 'trace,warning,error,info,profile';
  $loggerId = uniqidex ( "{$type}_" );
  /** @var CLogroute $route */
  ?>
<h3><?php echo $loggerId; ?></h3>
<form method="post">
  <input type="hidden" name="loggerId" value="<?php echo $loggerId; ?>">
  <table class="table table-condensed">
    <thead>
      <tr>
        <th>Key</th>
        <th>Type</th>
        <th>Value</th>
      </tr>
    </thead>
    <tbody>
<?php
  $skipKeys = array (
      'init',
      'detachBehaviors',
      'enableBehaviors',
      'disableBehaviors' 
  );
  foreach ( get_object_readable ( $route ) as $key )
  {
    if (array_value_exists ( $skipKeys, $key ))
      continue;
      // if (! isset ( $route->$key ))
      // continue;
    $doc = get_object_var_doc ( $route, $key );
    $doc = htmlspecialchars ( $doc );
    $value = $route->$key;
    $valueType = getTypeEx ( $value );
    $valueStr = _2str ( $value );
    
    echo ("
      <tr title=\"$doc\">
  <td>{$key}</td>
  <td>{$valueType}</td>
  <td><textarea name=\"{$loggerId}_{$key}\">{$valueStr}</textarea></td>
  </tr>
  
      ");
  }
  ?>
</tbody>
  </table>
  <input type="submit">
</form>
<?php
}
else
{
  $loggerId = $_REQUEST ['loggerId'];
  $params = array ();
  foreach ( $_REQUEST as $key => $value )
  {
    $paramname = startsWithGet ( $key, "{$loggerId}_" );
    if ($paramname != null)
      $params [$paramname] = array_from_code_to_array ( $value );
  }
  
  $params ['class'] = $type;
  
  $newcfg = array (
      'configWeb' => array (
          'components' => array (
              'log' => array (
                  'routes' => array (
                      $loggerId => $params 
                  ) 
              ) 
          ) 
      ) 
  );
  
  // var_dump_html($newcfg);
  $saved = file_put_contents ( pathCombine ( app ()->basePath, 'config', "logger_{$loggerId}.php" ), array_from_array_to_code ( $newcfg, true ) );
  if ($saved)
    echo "OK";
  else
    echo "ERROR";
}
?>