<?php

$modelFiles = getFiles(pathCombine(app()->basePath,'models'),"*.php",true);
$modelClasses = array();
foreach($modelFiles as $modelFile)
{
  $className = basename_wo_ext($modelFile);
  if(class_exists($className))
  {
    $parents = class_parents($className);
    if(array_value_exists($parents, "ActiveRecord"))
      $modelClasses[] = $className;
  }
}

?>
<h3>Create Relation</h3>
<h4>Choose Models</h4>
<form method="post">
<input type="hidden" name="step" value="step2_choose_fields" />
  <table style="width: 100%; border: solid black 1px;">
    <thead>
      <tr>
        <th style="width: 33%"></th>
        <th style="width: 33%"></th>
        <th style="width: 33%"></th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td style="width: 33%"><?php 
        echo CHtml::dropDownList('class_1', null, $modelClasses, array('style'=>'width: 100%;'));
        ?>
        </td>
        <td style="width: 33%"><select name="relation"
          style="width: 100%;">
            <option value="HAS_ONE">HAS_ONE</option>
            <option value="HAS_MANY">HAS_MANY</option>
            <option value="MANY_MANY">MANY_MANY</option>
            <option value="BELONGS_TO">BELONGS_TO</option>
            <option value="STAT">STAT</option>
        </select> <br />Many Many Bridge Class <?php 
        echo CHtml::dropDownList('class_bridge', null, $modelClasses, array('style'=>'width: 100%;'));
        ?>
        </td>
        <td style="width: 33%"><?php 
        echo CHtml::dropDownList('class_2', null, $modelClasses, array('style'=>'width: 100%;'));
        ?>
        </td>
      </tr>
    </tbody>
  </table>
  Relation name: <input type="text" name="name" /><br /> Conditions: <input
    type="text" name="conditions" /><br /> <input type="submit" />
</form>
<?php 


?>